/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.properties;

import org.neo4j.kernel.api.EntityType;
import org.neo4j.kernel.api.exceptions.PropertyNotFoundException;
import org.neo4j.kernel.api.properties.Property;

final class NoProperty
extends Property {
    private final EntityType entityType;
    private final long entityId;

    NoProperty(int propertyKeyId, EntityType entityType, long entityId) {
        super(propertyKeyId);
        this.entityType = entityType;
        this.entityId = entityId;
    }

    public String toString() {
        StringBuilder string = new StringBuilder(this.getClass().getSimpleName());
        string.append("[").append(this.entityType.name().toLowerCase());
        if (this.entityType == EntityType.GRAPH) {
            string.append("Property");
        } else {
            string.append("Id=").append(this.entityId);
        }
        string.append(", propertyKeyId=").append(this.propertyKeyId);
        return string.append("]").toString();
    }

    @Override
    public boolean equals(Object o) {
        return this == o || o instanceof NoProperty && this.propertyKeyId == ((NoProperty)o).propertyKeyId;
    }

    @Override
    public boolean isDefined() {
        return false;
    }

    @Override
    public int hashCode() {
        return this.propertyKeyId;
    }

    @Override
    public boolean valueEquals(Object value) {
        return false;
    }

    @Override
    public Object value(Object defaultValue) {
        return defaultValue;
    }

    @Override
    public String stringValue(String defaultValue) {
        return defaultValue;
    }

    @Override
    public String valueAsString() throws PropertyNotFoundException {
        throw new PropertyNotFoundException(this.propertyKeyId, this.entityType, this.entityId);
    }

    @Override
    public Number numberValue(Number defaultValue) {
        return defaultValue;
    }

    @Override
    public int intValue(int defaultValue) {
        return defaultValue;
    }

    @Override
    public long longValue(long defaultValue) {
        return defaultValue;
    }

    @Override
    public boolean booleanValue(boolean defaultValue) {
        return defaultValue;
    }

    @Override
    public Object value() throws PropertyNotFoundException {
        throw new PropertyNotFoundException(this.propertyKeyId, this.entityType, this.entityId);
    }

    @Override
    public String stringValue() throws PropertyNotFoundException {
        throw new PropertyNotFoundException(this.propertyKeyId, this.entityType, this.entityId);
    }

    @Override
    public boolean booleanValue() throws PropertyNotFoundException {
        throw new PropertyNotFoundException(this.propertyKeyId, this.entityType, this.entityId);
    }

    @Override
    public Number numberValue() throws PropertyNotFoundException {
        throw new PropertyNotFoundException(this.propertyKeyId, this.entityType, this.entityId);
    }

    @Override
    public int intValue() throws PropertyNotFoundException {
        throw new PropertyNotFoundException(this.propertyKeyId, this.entityType, this.entityId);
    }

    @Override
    public long longValue() throws PropertyNotFoundException {
        throw new PropertyNotFoundException(this.propertyKeyId, this.entityType, this.entityId);
    }
}

