/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.expr.aggregate;

import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.ExprEvalException;
import com.hp.hpl.jena.sparql.expr.NodeValue;
import com.hp.hpl.jena.sparql.expr.aggregate.Accumulator;
import com.hp.hpl.jena.sparql.function.FunctionEnv;

abstract class AccumulatorExpr
implements Accumulator {
    private long count = 0L;
    protected long errorCount = 0L;
    private final Expr expr;

    protected AccumulatorExpr(Expr expr) {
        this.expr = expr;
    }

    @Override
    public final void accumulate(Binding binding, FunctionEnv functionEnv) {
        try {
            NodeValue nv = this.expr.eval(binding, functionEnv);
            this.accumulate(nv, binding, functionEnv);
            ++this.count;
        }
        catch (ExprEvalException ex) {
            ++this.errorCount;
            this.accumulateError(binding, functionEnv);
        }
    }

    @Override
    public NodeValue getValue() {
        if (this.errorCount == 0L) {
            return this.getAccValue();
        }
        return null;
    }

    protected long getErrorCount() {
        return this.errorCount;
    }

    protected abstract NodeValue getAccValue();

    protected abstract void accumulate(NodeValue var1, Binding var2, FunctionEnv var3);

    protected abstract void accumulateError(Binding var1, FunctionEnv var2);
}

