/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.policy.builders;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.ws.policy.AssertionBuilder;
import org.apache.cxf.ws.policy.PolicyAssertion;
import org.apache.cxf.ws.policy.PolicyBuilder;
import org.apache.cxf.ws.security.policy.SP11Constants;
import org.apache.cxf.ws.security.policy.SP12Constants;
import org.apache.cxf.ws.security.policy.SPConstants;
import org.apache.cxf.ws.security.policy.model.AlgorithmSuite;
import org.apache.cxf.ws.security.policy.model.Layout;
import org.apache.cxf.ws.security.policy.model.ProtectionToken;
import org.apache.cxf.ws.security.policy.model.SymmetricBinding;
import org.apache.neethi.Assertion;
import org.apache.neethi.Policy;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SymmetricBindingBuilder
implements AssertionBuilder {
    private static final List<QName> KNOWN_ELEMENTS = Arrays.asList(SP11Constants.SYMMETRIC_BINDING, SP12Constants.SYMMETRIC_BINDING);
    PolicyBuilder builder;

    public SymmetricBindingBuilder(PolicyBuilder b) {
        this.builder = b;
    }

    public List<QName> getKnownElements() {
        return KNOWN_ELEMENTS;
    }

    public PolicyAssertion build(Element element) throws IllegalArgumentException {
        SPConstants consts = "http://schemas.xmlsoap.org/ws/2005/07/securitypolicy".equals(element.getNamespaceURI()) ? SP11Constants.INSTANCE : SP12Constants.INSTANCE;
        SymmetricBinding symmetricBinding = new SymmetricBinding(consts);
        Policy policy = this.builder.getPolicy(DOMUtils.getFirstElement((Node)element));
        Iterator iterator = (policy = (Policy)policy.normalize(false)).getAlternatives();
        if (iterator.hasNext()) {
            this.processAlternatives((List)iterator.next(), symmetricBinding, consts);
        }
        return symmetricBinding;
    }

    private void processAlternatives(List assertions, SymmetricBinding symmetricBinding, SPConstants consts) {
        for (Assertion assertion : assertions) {
            QName name = assertion.getName();
            if (!consts.getNamespace().equals(name.getNamespaceURI())) continue;
            if ("AlgorithmSuite".equals(name.getLocalPart())) {
                symmetricBinding.setAlgorithmSuite((AlgorithmSuite)assertion);
                continue;
            }
            if ("Layout".equals(name.getLocalPart())) {
                symmetricBinding.setLayout((Layout)assertion);
                continue;
            }
            if ("IncludeTimestamp".equals(name.getLocalPart())) {
                symmetricBinding.setIncludeTimestamp(true);
                continue;
            }
            if ("ProtectionToken".equals(name.getLocalPart())) {
                symmetricBinding.setProtectionToken((ProtectionToken)assertion);
                continue;
            }
            if ("EncryptBeforeSigning".equals(name.getLocalPart())) {
                symmetricBinding.setProtectionOrder("EncryptBeforeSigning");
                continue;
            }
            if ("SignBeforeEncrypting".equals(name.getLocalPart())) {
                symmetricBinding.setProtectionOrder("SignBeforeEncrypting");
                continue;
            }
            if ("OnlySignEntireHeadersAndBody".equals(name.getLocalPart())) {
                symmetricBinding.setEntireHeadersAndBodySignatures(true);
                continue;
            }
            if (!"EncryptSignature".equals(name.getLocalPart())) continue;
            symmetricBinding.setSignatureProtection(true);
        }
    }

    public PolicyAssertion buildCompatible(PolicyAssertion a, PolicyAssertion b) {
        return null;
    }
}

