/*
 * Decompiled with CFR 0.152.
 */
package opendap.dap.parser;

import java.util.Iterator;
import opendap.dap.Attribute;
import opendap.dap.AttributeTable;
import opendap.dap.BaseType;
import opendap.dap.BaseTypeFactory;
import opendap.dap.DAS;
import opendap.dap.DArray;
import opendap.dap.DArrayDimension;
import opendap.dap.DDS;
import opendap.dap.DDSException;
import opendap.dap.DGrid;
import opendap.dap.DSequence;
import opendap.dap.DefaultFactory;
import opendap.dap.parser.Daplex;
import opendap.dap.parser.OClist;
import opendap.dap.parser.ParseException;

abstract class Dapparse {
    static final int NA = 1;
    BaseTypeFactory factory = null;
    Daplex lexstate = null;
    Dapparse parsestate = this;
    DDS ddsroot = null;
    DAS dasroot = null;
    boolean svcerr = false;
    String code = null;
    String message = null;
    String ptype = null;
    String prog = null;
    protected int dapdebug = 0;

    public Dapparse() {
        this(new DefaultFactory());
    }

    public Dapparse(BaseTypeFactory factory) {
        this.factory = factory == null ? new DefaultFactory() : factory;
    }

    public abstract boolean parse() throws ParseException;

    abstract int getDebugLevel();

    abstract void setDebugLevel(int var1);

    String strdup(String s) {
        return s;
    }

    void cleanup() {
        this.ddsroot = null;
        this.dasroot = null;
        this.factory = null;
        this.lexstate = null;
    }

    public DDS getDDSroot() {
        return this.ddsroot;
    }

    public DAS getDASroot() {
        return this.dasroot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void Dataset(DDS dds, BaseTypeFactory factory) throws ParseException, DDSException {
        this.dapdebug = this.getDebugLevel();
        this.ddsroot = dds;
        this.factory = factory;
        try {
            Boolean accept = this.parse();
            if (!accept.booleanValue()) {
                throw new ParseException("Parse failed");
            }
        }
        finally {
            this.cleanup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void Attributes(DAS das) throws ParseException {
        this.dapdebug = this.getDebugLevel();
        this.dasroot = das;
        try {
            Boolean accept = this.parse();
            if (!accept.booleanValue()) {
                throw new ParseException("Parse failed");
            }
        }
        finally {
            this.cleanup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void Errorbody() throws ParseException {
        try {
            Boolean accept = this.parse();
            if (!accept.booleanValue()) {
                throw new ParseException("Parse failed");
            }
        }
        finally {
            this.cleanup();
        }
    }

    void dassetup(Dapparse parsestate) throws ParseException {
        this.lexstate.dassetup();
    }

    Object datasetbody(Dapparse state, Object name, Object decls) throws ParseException {
        this.ddsroot.setName((String)name);
        for (Object o : (OClist)decls) {
            this.ddsroot.addVariable((BaseType)o);
        }
        if (this.dapdebug > 0) {
            System.err.println("datasetbody:");
            this.ddsroot.print(System.err);
        }
        return null;
    }

    Object attributebody(Dapparse state, Object attrlist) throws ParseException {
        try {
            for (Object o : (OClist)attrlist) {
                if (o instanceof Attribute) {
                    Attribute a = (Attribute)o;
                    Iterator it = a.getValuesIterator();
                    while (it.hasNext()) {
                        this.dasroot.appendAttribute(a.getName(), a.getType(), (String)it.next());
                    }
                    continue;
                }
                if (o instanceof AttributeTable) {
                    AttributeTable aset = (AttributeTable)o;
                    this.dasroot.addAttributeTable(aset.getName(), aset);
                    continue;
                }
                throw new Exception("attribute body: unknown object: " + o);
            }
        }
        catch (Exception e) {
            throw new ParseException(e);
        }
        return null;
    }

    Object errorbody(Dapparse state, Object code, Object msg, Object ptype, Object prog) throws ParseException {
        this.svcerr = true;
        this.code = code == null ? null : code.toString();
        this.message = msg == null ? null : msg.toString();
        this.ptype = ptype == null ? null : ptype.toString();
        this.prog = prog == null ? null : prog.toString();
        return null;
    }

    Object unrecognizedresponse(Dapparse state) throws ParseException {
        return this.errorbody(state, "0", state.lexstate.input, null, null);
    }

    Object declarations(Dapparse state, Object decls, Object decl) throws ParseException {
        OClist alist = (OClist)decls;
        if (alist == null) {
            alist = new OClist();
        } else {
            alist.add((BaseType)decl);
        }
        return alist;
    }

    Object arraydecls(Dapparse state, Object arraydecls, Object arraydecl) throws ParseException {
        OClist alist = (OClist)arraydecls;
        if (alist == null) {
            alist = new OClist();
        } else {
            alist.add(arraydecl);
        }
        return alist;
    }

    Object arraydecl(Dapparse state, Object name, Object size) throws ParseException {
        int value;
        try {
            value = Integer.decode((String)size);
        }
        catch (NumberFormatException nfe) {
            throw new ParseException("Dimension " + name + " is not an integer: " + size, nfe);
        }
        DArrayDimension dim = new DArrayDimension(value, (String)name);
        return dim;
    }

    Object attrlist(Dapparse state, Object attrlist, Object attrtuple) throws ParseException {
        OClist alist = (OClist)attrlist;
        if (alist == null) {
            alist = new OClist();
        } else if (attrtuple != null) {
            alist.add(attrtuple);
            String dupname = this.scopeduplicates(alist);
            if (dupname != null) {
                this.dap_parse_error(state, "Duplicate attribute names in same scope: %s", dupname);
                alist.pop();
            }
        }
        return alist;
    }

    Object attrvalue(Dapparse state, Object valuelist, Object value, Object etype) throws ParseException {
        OClist alist = (OClist)valuelist;
        if (alist == null) {
            alist = new OClist();
        }
        if (value == null) {
            value = "";
        }
        alist.add(value);
        return alist;
    }

    Object attribute(Dapparse state, Object name, Object values, Object etype) throws ParseException {
        Attribute att = new Attribute((String)name, this.attributetypefor((Integer)etype));
        try {
            for (Object o : (OClist)values) {
                att.appendValue((String)o, true);
            }
        }
        catch (Exception e) {
            throw new ParseException(e);
        }
        return att;
    }

    Object attrset(Dapparse state, Object name, Object attributes) throws ParseException {
        try {
            AttributeTable attset = new AttributeTable((String)name);
            for (Object o : (OClist)attributes) {
                if (o instanceof Attribute) {
                    Attribute a = (Attribute)o;
                    Iterator it = a.getValuesIterator();
                    while (it.hasNext()) {
                        attset.appendAttribute(a.getName(), a.getType(), (String)it.next());
                    }
                    continue;
                }
                if (o instanceof AttributeTable) {
                    AttributeTable at = (AttributeTable)o;
                    attset.addContainer(at.getName(), at);
                    continue;
                }
                throw new ParseException("attrset: unexpected object: " + o);
            }
            return attset;
        }
        catch (Exception e) {
            throw new ParseException(e);
        }
    }

    Object makebase(Dapparse state, Object name, Object etype, Object dimensions) throws ParseException {
        OClist dims = (OClist)dimensions;
        BaseType node2 = this.basetypefor((Integer)etype, (String)name);
        if (dims.size() > 0) {
            DArray array = state.factory.newDArray();
            array.addVariable(node2);
            this.dimension(array, dims);
            node2 = array;
        }
        return node2;
    }

    void dimension(DArray node2, OClist dimensions) throws ParseException {
        int rank = dimensions.size();
        for (Object o : dimensions) {
            DArrayDimension dim = (DArrayDimension)o;
            node2.appendDim(dim.getSize(), dim.getName());
        }
    }

    Object makestructure(Dapparse state, Object name, Object dimensions, Object fields) throws ParseException {
        OClist dimset = (OClist)dimensions;
        String dupname = this.scopeduplicates((OClist)fields);
        if (dupname != null) {
            this.dap_parse_error(state, "Duplicate structure field names in same scope: %s.%s", (String)name, dupname);
            return null;
        }
        BaseType node2 = this.factory.newDStructure((String)name);
        OClist list = (OClist)fields;
        for (Object o : list) {
            node2.addVariable((BaseType)o, 1);
        }
        if (dimset.size() > 0) {
            DArray anode = this.factory.newDArray();
            anode.addVariable(node2);
            this.dimension(anode, (OClist)dimensions);
            node2 = anode;
        }
        return node2;
    }

    Object makesequence(Dapparse state, Object name, Object members) throws ParseException {
        String dupname = this.scopeduplicates((OClist)members);
        if (dupname != null) {
            this.dap_parse_error(state, "Duplicate sequence member names in same scope: %s.%s", (String)name, dupname);
            return null;
        }
        DSequence node2 = this.factory.newDSequence((String)name);
        OClist list = (OClist)members;
        for (Object o : list) {
            node2.addVariable((BaseType)o, 1);
        }
        return node2;
    }

    Object makegrid(Dapparse state, Object name, Object arraydecl0, Object mapdecls0) throws ParseException {
        DArray arraydecl = (DArray)arraydecl0;
        OClist mapdecls = (OClist)mapdecls0;
        String dupname = this.scopeduplicates(mapdecls);
        if (dupname != null) {
            this.dap_parse_error(state, "Duplicate grid map names in same scope: %s.%s", (String)name, dupname);
            return null;
        }
        DGrid node2 = this.factory.newDGrid((String)name);
        node2.addVariable(arraydecl, 1);
        for (Object m : mapdecls) {
            node2.addVariable((BaseType)m, 2);
        }
        return node2;
    }

    String flatten(String s) throws ParseException {
        boolean whitespace = false;
        StringBuilder buf = new StringBuilder();
        block4: for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '\n': 
                case '\r': {
                    continue block4;
                }
                case '\t': {
                    buf.append(' ');
                    continue block4;
                }
                default: {
                    buf.append(c);
                }
            }
        }
        return buf.toString();
    }

    int daperror(Dapparse state, String msg) throws ParseException {
        this.dap_parse_error(state, msg, new Object[0]);
        return 0;
    }

    void dap_parse_error(Dapparse state, String fmt, Object ... args) throws ParseException {
        System.err.println(String.format(fmt, args));
        String tmp = null;
        int len = this.lexstate.getInput().length();
        tmp = this.flatten(this.lexstate.getInput());
        throw new ParseException("context: " + tmp + "^");
    }

    BaseType basetypefor(Integer etype, String name) throws ParseException {
        switch (etype) {
            case 261: {
                return this.factory.newDByte(name);
            }
            case 269: {
                return this.factory.newDInt16(name);
            }
            case 276: {
                return this.factory.newDUInt16(name);
            }
            case 270: {
                return this.factory.newDInt32(name);
            }
            case 277: {
                return this.factory.newDUInt32(name);
            }
            case 266: {
                return this.factory.newDFloat32(name);
            }
            case 267: {
                return this.factory.newDFloat64(name);
            }
            case 278: {
                return this.factory.newDURL(name);
            }
            case 274: {
                return this.factory.newDString(name);
            }
        }
        throw new ParseException("basetypefor: illegal type: " + etype);
    }

    int attributetypefor(Integer etype) throws ParseException {
        switch (etype) {
            case 261: {
                return 3;
            }
            case 269: {
                return 4;
            }
            case 276: {
                return 5;
            }
            case 270: {
                return 6;
            }
            case 277: {
                return 7;
            }
            case 266: {
                return 8;
            }
            case 267: {
                return 9;
            }
            case 278: {
                return 11;
            }
            case 274: {
                return 10;
            }
        }
        throw new ParseException("attributetypefor: illegal type: " + etype);
    }

    String scopeduplicates(OClist list) throws ParseException {
        for (int i = 0; i < list.size(); ++i) {
            Object io = list.get(i);
            String iname = this.extractname(io);
            for (int j = i + 1; j < list.size(); ++j) {
                Object jo = list.get(j);
                String jname = this.extractname(jo);
                if (!iname.equals(jname)) continue;
                return iname;
            }
        }
        return null;
    }

    String extractname(Object o) throws ParseException {
        if (o instanceof BaseType) {
            return ((BaseType)o).getName();
        }
        if (o instanceof Attribute) {
            return ((Attribute)o).getName();
        }
        if (o instanceof AttributeTable) {
            return ((AttributeTable)o).getName();
        }
        throw new ParseException("extractname: illegal object class: " + o);
    }
}

