/*
 * Decompiled with CFR 0.152.
 */
package com.webcohesion.enunciate.modules.jaxrs.model;

import com.webcohesion.enunciate.modules.jaxrs.EnunciateJaxrsContext;
import com.webcohesion.enunciate.modules.jaxrs.model.Resource;
import com.webcohesion.enunciate.modules.jaxrs.model.ResourceParameter;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.util.ElementFilter;
import javax.ws.rs.Path;

public class RootResource
extends Resource {
    public RootResource(TypeElement delegate, EnunciateJaxrsContext context) {
        super(delegate, RootResource.loadPath(delegate), context);
    }

    private static String loadPath(TypeElement delegate) {
        Path path = delegate.getAnnotation(Path.class);
        if (path == null) {
            throw new IllegalArgumentException("A JAX-RS root resource must be annotated with @javax.ws.rs.Path.");
        }
        return path.value();
    }

    @Override
    public Resource getParent() {
        return null;
    }

    @Override
    protected Set<ResourceParameter> getResourceParameters(TypeElement delegate, EnunciateJaxrsContext context) {
        Set<ResourceParameter> resourceParams = super.getResourceParameters(delegate, context);
        List<ExecutableElement> constructors = ElementFilter.constructorsIn(delegate.getEnclosedElements());
        ExecutableElement chosen = null;
        block0: for (ExecutableElement executableElement : constructors) {
            if (chosen != null && executableElement.getParameters().size() <= chosen.getParameters().size()) continue;
            for (VariableElement variableElement : executableElement.getParameters()) {
                if (ResourceParameter.isResourceParameter(variableElement, context)) continue;
                continue block0;
            }
            chosen = executableElement;
        }
        if (chosen != null) {
            for (VariableElement variableElement : chosen.getParameters()) {
                resourceParams.add(new ResourceParameter(variableElement, this));
            }
        }
        return resourceParams;
    }
}

