/*
 * Decompiled with CFR 0.152.
 */
package com.webcohesion.enunciate.modules.jaxrs.model;

import com.webcohesion.enunciate.EnunciateException;
import com.webcohesion.enunciate.facets.Facet;
import com.webcohesion.enunciate.facets.HasFacets;
import com.webcohesion.enunciate.javac.decorations.Annotations;
import com.webcohesion.enunciate.javac.decorations.TypeMirrorDecorator;
import com.webcohesion.enunciate.javac.decorations.element.DecoratedElement;
import com.webcohesion.enunciate.javac.decorations.element.DecoratedExecutableElement;
import com.webcohesion.enunciate.javac.decorations.type.DecoratedDeclaredType;
import com.webcohesion.enunciate.javac.decorations.type.DecoratedTypeMirror;
import com.webcohesion.enunciate.javac.decorations.type.TypeVariableContext;
import com.webcohesion.enunciate.javac.javadoc.JavaDoc;
import com.webcohesion.enunciate.metadata.rs.RequestHeader;
import com.webcohesion.enunciate.metadata.rs.RequestHeaders;
import com.webcohesion.enunciate.metadata.rs.ResourceLabel;
import com.webcohesion.enunciate.metadata.rs.ResourceMethodSignature;
import com.webcohesion.enunciate.metadata.rs.ResponseHeaders;
import com.webcohesion.enunciate.metadata.rs.StatusCodes;
import com.webcohesion.enunciate.metadata.rs.TypeHint;
import com.webcohesion.enunciate.metadata.rs.Warnings;
import com.webcohesion.enunciate.modules.jaxrs.EnunciateJaxrsContext;
import com.webcohesion.enunciate.modules.jaxrs.model.ExplicitResourceParameter;
import com.webcohesion.enunciate.modules.jaxrs.model.PathContext;
import com.webcohesion.enunciate.modules.jaxrs.model.PathSegment;
import com.webcohesion.enunciate.modules.jaxrs.model.Resource;
import com.webcohesion.enunciate.modules.jaxrs.model.ResourceEntityParameter;
import com.webcohesion.enunciate.modules.jaxrs.model.ResourceParameter;
import com.webcohesion.enunciate.modules.jaxrs.model.ResourceParameterType;
import com.webcohesion.enunciate.modules.jaxrs.model.ResourceRepresentationMetadata;
import com.webcohesion.enunciate.modules.jaxrs.model.ResponseCode;
import com.webcohesion.enunciate.modules.jaxrs.model.SubResource;
import com.webcohesion.enunciate.modules.jaxrs.model.util.JaxrsUtil;
import com.webcohesion.enunciate.modules.jaxrs.model.util.MediaType;
import com.webcohesion.enunciate.util.AnnotationUtils;
import com.webcohesion.enunciate.util.TypeHintUtils;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.ResponseHeader;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.security.RolesAllowed;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.MirroredTypeException;
import javax.lang.model.type.TypeMirror;
import javax.ws.rs.Consumes;
import javax.ws.rs.CookieParam;
import javax.ws.rs.HttpMethod;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

public class ResourceMethod
extends DecoratedExecutableElement
implements HasFacets,
PathContext {
    private static final Pattern CONTEXT_PARAM_PATTERN = Pattern.compile("\\{([^\\}]+)\\}");
    private final EnunciateJaxrsContext context;
    private final String subpath;
    private final String label;
    private final String customParameterName;
    private final Set<String> httpMethods;
    private final Set<MediaType> consumesMediaTypes;
    private final Set<MediaType> producesMediaTypes;
    private final Resource parent;
    private final Set<ResourceParameter> resourceParameters;
    private final ResourceEntityParameter entityParameter;
    private final Map<String, Object> metaData = new HashMap<String, Object>();
    private final List<? extends ResponseCode> statusCodes;
    private final List<? extends ResponseCode> warnings;
    private final Map<String, String> responseHeaders;
    private final ResourceRepresentationMetadata representationMetadata;
    private final Set<Facet> facets = new TreeSet<Facet>();
    private final List<PathSegment> pathComponents;

    public ResourceMethod(ExecutableElement delegate, Resource parent, TypeVariableContext variableContext, EnunciateJaxrsContext context) {
        super(delegate, (ProcessingEnvironment)context.getContext().getProcessingEnvironment());
        ResourceRepresentationMetadata outputPayload;
        Set<Object> resourceParameters;
        ResourceEntityParameter entityParameter;
        this.context = context;
        Set<String> httpMethods = this.loadHttpMethods(delegate);
        if (httpMethods.isEmpty()) {
            throw new IllegalStateException("A resource method must specify an HTTP method by using a request method designator annotation.");
        }
        this.httpMethods = httpMethods;
        this.consumesMediaTypes = this.loadConsumes(delegate, parent);
        this.producesMediaTypes = this.loadProduces(delegate, parent);
        String label = null;
        ResourceLabel resourceLabel = delegate.getAnnotation(ResourceLabel.class);
        if (resourceLabel != null && "##default".equals(label = resourceLabel.value())) {
            label = null;
        }
        String subpath = null;
        Path pathInfo = delegate.getAnnotation(Path.class);
        if (pathInfo != null) {
            subpath = pathInfo.value();
        }
        List<PathSegment> pathComponents = Resource.extractPathComponents(subpath);
        String customParameterName = null;
        ResourceMethodSignature signatureOverride = delegate.getAnnotation(ResourceMethodSignature.class);
        if (signatureOverride == null) {
            entityParameter = null;
            resourceParameters = new TreeSet();
            for (VariableElement parameterDeclaration : this.getParameters()) {
                if (ResourceParameter.isResourceParameter(parameterDeclaration, context)) {
                    resourceParameters.add(new ResourceParameter(parameterDeclaration, this));
                    continue;
                }
                if (ResourceParameter.isBeanParameter(parameterDeclaration)) {
                    resourceParameters.addAll(ResourceParameter.getFormBeanParameters(parameterDeclaration, this));
                    continue;
                }
                if (ResourceParameter.isSystemParameter(parameterDeclaration, context)) continue;
                entityParameter = new ResourceEntityParameter(this, parameterDeclaration, variableContext, context);
                customParameterName = parameterDeclaration.getSimpleName().toString();
            }
            DecoratedTypeMirror returnType = this.loadReturnType();
            String docComment = returnType.getDocComment();
            returnType = (DecoratedTypeMirror)TypeMirrorDecorator.decorate((TypeMirror)variableContext.resolveTypeVariables((TypeMirror)returnType, (ProcessingEnvironment)this.env), (ProcessingEnvironment)this.env);
            returnType.setDocComment(docComment);
            outputPayload = returnType.isVoid() ? null : new ResourceRepresentationMetadata(returnType);
        } else {
            entityParameter = this.loadEntityParameter(signatureOverride);
            resourceParameters = this.loadResourceParameters(signatureOverride);
            outputPayload = this.loadOutputPayload(signatureOverride);
        }
        resourceParameters.addAll(this.loadExtraParameters(parent, context));
        this.entityParameter = entityParameter;
        this.resourceParameters = resourceParameters;
        this.subpath = subpath;
        this.label = label;
        this.customParameterName = customParameterName;
        this.parent = parent;
        this.statusCodes = this.loadStatusCodes(parent);
        this.warnings = this.loadWarnings(parent);
        this.representationMetadata = outputPayload;
        this.facets.addAll(Facet.gatherFacets((Element)delegate));
        this.facets.addAll(parent.getFacets());
        this.pathComponents = pathComponents;
        this.responseHeaders = this.loadResponseHeaders(parent);
    }

    protected Set<String> loadHttpMethods(ExecutableElement delegate) {
        TreeSet<String> httpMethods = new TreeSet<String>();
        List<? extends AnnotationMirror> mirrors = delegate.getAnnotationMirrors();
        for (AnnotationMirror annotationMirror : mirrors) {
            Element annotationDeclaration = annotationMirror.getAnnotationType().asElement();
            HttpMethod httpMethodInfo = annotationDeclaration.getAnnotation(HttpMethod.class);
            if (httpMethodInfo == null) continue;
            httpMethods.add(httpMethodInfo.value());
        }
        ApiOperation apiOperation = delegate.getAnnotation(ApiOperation.class);
        if (apiOperation != null && !apiOperation.httpMethod().isEmpty()) {
            httpMethods.clear();
            httpMethods.add(apiOperation.httpMethod());
        }
        return httpMethods;
    }

    public Map<String, String> loadResponseHeaders(Resource parent) {
        HashMap<String, String> responseHeaders = new HashMap<String, String>();
        ResponseHeaders responseHeaderInfo = (ResponseHeaders)this.getAnnotation(ResponseHeaders.class);
        if (responseHeaderInfo != null) {
            for (com.webcohesion.enunciate.metadata.rs.ResponseHeader header : responseHeaderInfo.value()) {
                responseHeaders.put(header.name(), header.description());
            }
        }
        List inheritedResponseHeaders = AnnotationUtils.getAnnotations(ResponseHeaders.class, (Element)((Object)parent));
        for (ResponseHeaders inheritedResponseHeader : inheritedResponseHeaders) {
            for (com.webcohesion.enunciate.metadata.rs.ResponseHeader header : inheritedResponseHeader.value()) {
                responseHeaders.put(header.name(), header.description());
            }
        }
        JavaDoc.JavaDocTagList doclets = (JavaDoc.JavaDocTagList)this.getJavaDoc().get((Object)"ResponseHeader");
        if (doclets != null) {
            for (String doclet : doclets) {
                int firstspace = doclet.indexOf(32);
                String header = firstspace > 0 ? doclet.substring(0, firstspace) : doclet;
                String doc = firstspace > 0 && firstspace + 1 < doclet.length() ? doclet.substring(firstspace + 1) : "";
                responseHeaders.put(header, doc);
            }
        }
        List inheritedDoclets = AnnotationUtils.getJavaDocTags((String)"ResponseHeader", (DecoratedElement)parent);
        for (JavaDoc.JavaDocTagList inheritedDoclet : inheritedDoclets) {
            for (String doclet : inheritedDoclet) {
                int firstspace = doclet.indexOf(32);
                String header = firstspace > 0 ? doclet.substring(0, firstspace) : doclet;
                String doc = firstspace > 0 && firstspace + 1 < doclet.length() ? doclet.substring(firstspace + 1) : "";
                responseHeaders.put(header, doc);
            }
        }
        return responseHeaders;
    }

    public ArrayList<ResponseCode> loadWarnings(Resource parent) {
        ResponseCode rc;
        ArrayList<ResponseCode> warnings = new ArrayList<ResponseCode>();
        Warnings warningInfo = (Warnings)this.getAnnotation(Warnings.class);
        if (warningInfo != null) {
            for (com.webcohesion.enunciate.metadata.rs.ResponseCode code : warningInfo.value()) {
                ResponseCode rc2 = new ResponseCode(this);
                rc2.setCode(code.code());
                rc2.setCondition(code.condition());
                warnings.add(rc2);
            }
        }
        List inheritedWarnings = AnnotationUtils.getAnnotations(Warnings.class, (Element)((Object)parent));
        for (Warnings inheritedWarning : inheritedWarnings) {
            for (com.webcohesion.enunciate.metadata.rs.ResponseCode code : inheritedWarning.value()) {
                rc = new ResponseCode(this);
                rc.setCode(code.code());
                rc.setCondition(code.condition());
                warnings.add(rc);
            }
        }
        JavaDoc.JavaDocTagList doclets = (JavaDoc.JavaDocTagList)this.getJavaDoc().get((Object)"HTTPWarning");
        if (doclets != null) {
            for (String doclet : doclets) {
                int firstspace = doclet.indexOf(32);
                String code = firstspace > 0 ? doclet.substring(0, firstspace) : doclet;
                String doc = firstspace > 0 && firstspace + 1 < doclet.length() ? doclet.substring(firstspace + 1) : "";
                try {
                    rc = new ResponseCode(this);
                    rc.setCode(Integer.parseInt(code));
                    rc.setCondition(doc);
                    warnings.add(rc);
                }
                catch (NumberFormatException e) {}
            }
        }
        List inheritedDoclets = AnnotationUtils.getJavaDocTags((String)"HTTPWarning", (DecoratedElement)parent);
        for (JavaDoc.JavaDocTagList inheritedDoclet : inheritedDoclets) {
            for (String doclet : inheritedDoclet) {
                int firstspace = doclet.indexOf(32);
                String code = firstspace > 0 ? doclet.substring(0, firstspace) : doclet;
                String doc = firstspace > 0 && firstspace + 1 < doclet.length() ? doclet.substring(firstspace + 1) : "";
                try {
                    ResponseCode rc3 = new ResponseCode(this);
                    rc3.setCode(Integer.parseInt(code));
                    rc3.setCondition(doc);
                    warnings.add(rc3);
                }
                catch (NumberFormatException e) {}
            }
        }
        return warnings;
    }

    protected Set<MediaType> loadConsumes(ExecutableElement delegate, Resource parent) {
        Consumes consumesInfo = delegate.getAnnotation(Consumes.class);
        TreeSet<MediaType> consumes = consumesInfo != null ? new TreeSet<MediaType>(JaxrsUtil.value(consumesInfo)) : new TreeSet<MediaType>(parent.getConsumesMediaTypes());
        ApiOperation apiOperation = delegate.getAnnotation(ApiOperation.class);
        if (apiOperation != null && !apiOperation.consumes().isEmpty()) {
            consumes = new TreeSet();
            for (String mediaType : apiOperation.consumes().split(",")) {
                if ((mediaType = mediaType.trim()).isEmpty()) continue;
                consumes.add(new MediaType(mediaType, 1.0f));
            }
        }
        return consumes;
    }

    protected Set<MediaType> loadProduces(ExecutableElement delegate, Resource parent) {
        Produces producesInfo = delegate.getAnnotation(Produces.class);
        TreeSet<MediaType> produces = producesInfo != null ? new TreeSet<MediaType>(JaxrsUtil.value(producesInfo)) : new TreeSet<MediaType>(parent.getProducesMediaTypes());
        ApiOperation apiOperation = delegate.getAnnotation(ApiOperation.class);
        if (apiOperation != null && !apiOperation.produces().isEmpty()) {
            produces = new TreeSet();
            for (String mediaType : apiOperation.produces().split(",")) {
                if ((mediaType = mediaType.trim()).isEmpty()) continue;
                produces.add(new MediaType(mediaType, 1.0f));
            }
        }
        return produces;
    }

    protected DecoratedTypeMirror loadReturnType() {
        DecoratedTypeMirror swaggerReturnType;
        DecoratedTypeMirror returnType;
        TypeHint hintInfo = (TypeHint)this.getAnnotation(TypeHint.class);
        if (hintInfo != null) {
            returnType = (DecoratedTypeMirror)TypeHintUtils.getTypeHint((TypeHint)hintInfo, (ProcessingEnvironment)this.env, (TypeMirror)this.getReturnType());
            returnType.setDocComment(((DecoratedTypeMirror)this.getReturnType()).getDocComment());
        } else {
            returnType = (DecoratedTypeMirror)this.getReturnType();
            if (returnType.isClass() && returnType.isInstanceOf("com.sun.jersey.api.JResponse")) {
                DecoratedTypeMirror responseType;
                DecoratedDeclaredType jresponse = (DecoratedDeclaredType)returnType;
                if (!jresponse.getTypeArguments().isEmpty() && (responseType = (DecoratedTypeMirror)TypeMirrorDecorator.decorate((TypeMirror)((TypeMirror)jresponse.getTypeArguments().get(0)), (ProcessingEnvironment)this.env)).isDeclared()) {
                    responseType.setDocComment(returnType.getDocComment());
                    returnType = responseType;
                }
            } else if (returnType.isInstanceOf(Response.class) || returnType.isInstanceOf(InputStream.class)) {
                DecoratedDeclaredType objectType = (DecoratedDeclaredType)TypeMirrorDecorator.decorate((TypeMirror)this.env.getElementUtils().getTypeElement(Object.class.getName()).asType(), (ProcessingEnvironment)this.env);
                objectType.setDocComment(returnType.getDocComment());
                returnType = objectType;
            }
        }
        final ApiOperation apiOperation = (ApiOperation)this.getAnnotation(ApiOperation.class);
        if (apiOperation != null && (swaggerReturnType = Annotations.mirrorOf((Callable)new Callable<Class<?>>(){

            @Override
            public Class<?> call() throws Exception {
                return apiOperation.response();
            }
        }, (ProcessingEnvironment)this.env, Void.class)) != null) {
            if (!apiOperation.responseContainer().isEmpty()) {
                swaggerReturnType = (DecoratedTypeMirror)this.env.getTypeUtils().getArrayType((TypeMirror)swaggerReturnType);
            }
            returnType = swaggerReturnType;
        }
        if (this.getJavaDoc().get((Object)"returnWrapped") != null) {
            TypeElement type;
            String fqn = (String)((JavaDoc.JavaDocTagList)this.getJavaDoc().get((Object)"returnWrapped")).get(0);
            boolean array = false;
            if (fqn.endsWith("[]")) {
                array = true;
                fqn = fqn.substring(0, fqn.length() - 2);
            }
            if ((type = this.env.getElementUtils().getTypeElement(fqn)) != null) {
                returnType = (DecoratedTypeMirror)TypeMirrorDecorator.decorate((TypeMirror)this.env.getTypeUtils().getDeclaredType(type, new TypeMirror[0]), (ProcessingEnvironment)this.env);
                if (array) {
                    returnType = (DecoratedTypeMirror)TypeMirrorDecorator.decorate((TypeMirror)this.env.getTypeUtils().getArrayType((TypeMirror)returnType), (ProcessingEnvironment)this.env);
                }
            }
        }
        return returnType;
    }

    public Set<ResourceParameter> loadExtraParameters(Resource parent, EnunciateJaxrsContext context) {
        ApiImplicitParams swaggerImplicitParams;
        TreeSet<ResourceParameter> extraParameters = new TreeSet<ResourceParameter>();
        JavaDoc.JavaDocTagList doclets = (JavaDoc.JavaDocTagList)this.getJavaDoc().get((Object)"RequestHeader");
        if (doclets != null) {
            for (String doclet : doclets) {
                int firstspace = doclet.indexOf(32);
                String header = firstspace > 0 ? doclet.substring(0, firstspace) : doclet;
                String doc = firstspace > 0 && firstspace + 1 < doclet.length() ? doclet.substring(firstspace + 1) : "";
                extraParameters.add(new ExplicitResourceParameter(this, doc, header, ResourceParameterType.HEADER, context));
            }
        }
        List inheritedDoclets = AnnotationUtils.getJavaDocTags((String)"RequestHeader", (DecoratedElement)parent);
        for (JavaDoc.JavaDocTagList inheritedDoclet : inheritedDoclets) {
            for (String doclet : inheritedDoclet) {
                int firstspace = doclet.indexOf(32);
                String header = firstspace > 0 ? doclet.substring(0, firstspace) : doclet;
                String doc = firstspace > 0 && firstspace + 1 < doclet.length() ? doclet.substring(firstspace + 1) : "";
                extraParameters.add(new ExplicitResourceParameter(this, doc, header, ResourceParameterType.HEADER, context));
            }
        }
        RequestHeaders requestHeaders = (RequestHeaders)this.getAnnotation(RequestHeaders.class);
        if (requestHeaders != null) {
            for (RequestHeader header : requestHeaders.value()) {
                extraParameters.add(new ExplicitResourceParameter(this, header.description(), header.name(), ResourceParameterType.HEADER, context));
            }
        }
        List inheritedRequestHeaders = AnnotationUtils.getAnnotations(RequestHeaders.class, (Element)((Object)parent));
        for (RequestHeaders inheritedRequestHeader : inheritedRequestHeaders) {
            for (RequestHeader header : inheritedRequestHeader.value()) {
                extraParameters.add(new ExplicitResourceParameter(this, header.description(), header.name(), ResourceParameterType.HEADER, context));
            }
        }
        ApiOperation apiOperation = (ApiOperation)this.getAnnotation(ApiOperation.class);
        if (apiOperation != null) {
            ResponseHeader[] responseHeaders;
            for (ResponseHeader responseHeader : responseHeaders = apiOperation.responseHeaders()) {
                if (responseHeader.name().isEmpty()) continue;
                extraParameters.add(new ExplicitResourceParameter(this, responseHeader.description(), responseHeader.name(), ResourceParameterType.HEADER, context));
            }
        }
        if ((swaggerImplicitParams = (ApiImplicitParams)this.getAnnotation(ApiImplicitParams.class)) != null) {
            for (ApiImplicitParam swaggerImplicitParam : swaggerImplicitParams.value()) {
                ResourceParameterType parameterType;
                try {
                    parameterType = ResourceParameterType.valueOf(swaggerImplicitParam.paramType().toUpperCase());
                }
                catch (IllegalArgumentException e) {
                    continue;
                }
                extraParameters.add(new ExplicitResourceParameter(this, swaggerImplicitParam.value(), swaggerImplicitParam.name(), parameterType, context));
            }
        }
        return extraParameters;
    }

    public ArrayList<ResponseCode> loadStatusCodes(Resource parent) {
        ArrayList<ResponseCode> statusCodes = new ArrayList<ResponseCode>();
        StatusCodes codes = (StatusCodes)this.getAnnotation(StatusCodes.class);
        if (codes != null) {
            for (com.webcohesion.enunciate.metadata.rs.ResponseCode code : codes.value()) {
                ResponseCode rc = new ResponseCode(this);
                rc.setCode(code.code());
                rc.setCondition(code.condition());
                for (com.webcohesion.enunciate.metadata.rs.ResponseHeader header : code.additionalHeaders()) {
                    rc.setAdditionalHeader(header.name(), header.description());
                }
                rc.setType((DecoratedTypeMirror)TypeHintUtils.getTypeHint((TypeHint)code.type(), (ProcessingEnvironment)this.env, null));
                statusCodes.add(rc);
            }
        }
        List inheritedStatusCodes = AnnotationUtils.getAnnotations(StatusCodes.class, (Element)((Object)parent));
        for (StatusCodes inheritedStatusCode : inheritedStatusCodes) {
            for (com.webcohesion.enunciate.metadata.rs.ResponseCode code : inheritedStatusCode.value()) {
                ResponseCode rc = new ResponseCode(this);
                rc.setCode(code.code());
                rc.setCondition(code.condition());
                for (com.webcohesion.enunciate.metadata.rs.ResponseHeader header : code.additionalHeaders()) {
                    rc.setAdditionalHeader(header.name(), header.description());
                }
                rc.setType((DecoratedTypeMirror)TypeHintUtils.getTypeHint((TypeHint)code.type(), (ProcessingEnvironment)this.env, null));
                statusCodes.add(rc);
            }
        }
        JavaDoc.JavaDocTagList doclets = (JavaDoc.JavaDocTagList)this.getJavaDoc().get((Object)"HTTP");
        if (doclets != null) {
            for (String doclet : doclets) {
                int firstspace = doclet.indexOf(32);
                String code = firstspace > 0 ? doclet.substring(0, firstspace) : doclet;
                String doc = firstspace > 0 && firstspace + 1 < doclet.length() ? doclet.substring(firstspace + 1) : "";
                try {
                    ResponseCode rc = new ResponseCode(this);
                    rc.setCode(Integer.parseInt(code));
                    rc.setCondition(doc);
                    statusCodes.add(rc);
                }
                catch (NumberFormatException e) {}
            }
        }
        List inheritedDoclets = AnnotationUtils.getJavaDocTags((String)"HTTP", (DecoratedElement)parent);
        for (JavaDoc.JavaDocTagList inheritedDoclet : inheritedDoclets) {
            for (String doclet : inheritedDoclet) {
                int firstspace = doclet.indexOf(32);
                String code = firstspace > 0 ? doclet.substring(0, firstspace) : doclet;
                String doc = firstspace > 0 && firstspace + 1 < doclet.length() ? doclet.substring(firstspace + 1) : "";
                try {
                    ResponseCode rc = new ResponseCode(this);
                    rc.setCode(Integer.parseInt(code));
                    rc.setCondition(doc);
                    statusCodes.add(rc);
                }
                catch (NumberFormatException e) {}
            }
        }
        ApiResponses swaggerResponses = (ApiResponses)this.getAnnotation(ApiResponses.class);
        if (swaggerResponses != null) {
            for (ApiResponse swaggerResponse : swaggerResponses.value()) {
                ResponseHeader[] headers;
                ResponseCode rc = new ResponseCode(this);
                rc.setCode(swaggerResponse.code());
                rc.setCondition(swaggerResponse.message());
                for (ResponseHeader header : headers = swaggerResponse.responseHeaders()) {
                    if (header.name().isEmpty()) continue;
                    rc.setAdditionalHeader(header.name(), header.description());
                }
                statusCodes.add(rc);
            }
        }
        return statusCodes;
    }

    protected ResourceRepresentationMetadata loadOutputPayload(ResourceMethodSignature signatureOverride) {
        DecoratedTypeMirror returnType = (DecoratedTypeMirror)this.getReturnType();
        try {
            Class outputType = signatureOverride.output();
            if (outputType != ResourceMethodSignature.NONE.class) {
                TypeElement type = this.env.getElementUtils().getTypeElement(outputType.getName());
                return new ResourceRepresentationMetadata(this.env.getTypeUtils().getDeclaredType(type, new TypeMirror[0]), returnType.getDocValue());
            }
        }
        catch (MirroredTypeException e) {
            DecoratedTypeMirror typeMirror = (DecoratedTypeMirror)TypeMirrorDecorator.decorate((TypeMirror)e.getTypeMirror(), (ProcessingEnvironment)this.env);
            if (typeMirror.isDeclared()) {
                if (typeMirror.isInstanceOf(ResourceMethodSignature.class.getName() + ".NONE")) {
                    return null;
                }
                return new ResourceRepresentationMetadata((TypeMirror)typeMirror, returnType.getDocValue());
            }
            throw new EnunciateException(this.toString() + ": Illegal output type (must be a declared type): " + typeMirror);
        }
        return null;
    }

    protected static HashMap<String, String> parseParamComments(String tagName, JavaDoc jd) {
        HashMap<String, String> paramComments = new HashMap<String, String>();
        if (jd.get((Object)tagName) != null) {
            for (String paramDoc : (JavaDoc.JavaDocTagList)jd.get((Object)tagName)) {
                int spaceIndex = (paramDoc = paramDoc.trim().replaceFirst("\\s+", " ")).indexOf(32);
                if (spaceIndex == -1) {
                    spaceIndex = paramDoc.length();
                }
                String param = paramDoc.substring(0, spaceIndex);
                String paramComment = "";
                if (spaceIndex + 1 < paramDoc.length()) {
                    paramComment = paramDoc.substring(spaceIndex + 1);
                }
                paramComments.put(param, paramComment);
            }
        }
        return paramComments;
    }

    protected HashMap<String, String> loadParamsComments(JavaDoc jd) {
        HashMap<String, String> paramRESTComments = ResourceMethod.parseParamComments("RSParam", jd);
        HashMap<String, String> paramComments = ResourceMethod.parseParamComments("param", jd);
        paramComments.putAll(paramRESTComments);
        return paramComments;
    }

    protected Set<ResourceParameter> loadResourceParameters(ResourceMethodSignature signatureOverride) {
        HashMap<String, String> paramComments = this.loadParamsComments(this.getJavaDoc());
        TreeSet<ResourceParameter> params = new TreeSet<ResourceParameter>();
        for (CookieParam cookieParam : signatureOverride.cookieParams()) {
            params.add(new ExplicitResourceParameter(this, paramComments.get(cookieParam.value()), cookieParam.value(), ResourceParameterType.COOKIE, this.context));
        }
        for (CookieParam cookieParam : signatureOverride.matrixParams()) {
            params.add(new ExplicitResourceParameter(this, paramComments.get(cookieParam.value()), cookieParam.value(), ResourceParameterType.MATRIX, this.context));
        }
        for (CookieParam cookieParam : signatureOverride.queryParams()) {
            params.add(new ExplicitResourceParameter(this, paramComments.get(cookieParam.value()), cookieParam.value(), ResourceParameterType.QUERY, this.context));
        }
        for (CookieParam cookieParam : signatureOverride.pathParams()) {
            params.add(new ExplicitResourceParameter(this, paramComments.get(cookieParam.value()), cookieParam.value(), ResourceParameterType.PATH, this.context));
        }
        for (CookieParam cookieParam : signatureOverride.headerParams()) {
            params.add(new ExplicitResourceParameter(this, paramComments.get(cookieParam.value()), cookieParam.value(), ResourceParameterType.HEADER, this.context));
        }
        for (CookieParam cookieParam : signatureOverride.formParams()) {
            params.add(new ExplicitResourceParameter(this, paramComments.get(cookieParam.value()), cookieParam.value(), ResourceParameterType.FORM, this.context));
        }
        return params;
    }

    protected ResourceEntityParameter loadEntityParameter(ResourceMethodSignature signatureOverride) {
        try {
            Class entityType = signatureOverride.input();
            if (entityType != ResourceMethodSignature.NONE.class) {
                TypeElement type = this.env.getElementUtils().getTypeElement(entityType.getName());
                return new ResourceEntityParameter(type, this.env.getTypeUtils().getDeclaredType(type, new TypeMirror[0]), (ProcessingEnvironment)this.context.getContext().getProcessingEnvironment());
            }
        }
        catch (MirroredTypeException e) {
            DecoratedTypeMirror typeMirror = (DecoratedTypeMirror)TypeMirrorDecorator.decorate((TypeMirror)e.getTypeMirror(), (ProcessingEnvironment)this.context.getContext().getProcessingEnvironment());
            if (typeMirror.isDeclared()) {
                if (typeMirror.isInstanceOf(ResourceMethodSignature.class.getName() + ".NONE")) {
                    return null;
                }
                return new ResourceEntityParameter(((DeclaredType)typeMirror).asElement(), (TypeMirror)typeMirror, (ProcessingEnvironment)this.context.getContext().getProcessingEnvironment());
            }
            throw new EnunciateException(this.toString() + ": Illegal input type (must be a declared type): " + typeMirror);
        }
        return null;
    }

    @Override
    public EnunciateJaxrsContext getContext() {
        return this.context;
    }

    public Set<String> getHttpMethods() {
        return this.httpMethods;
    }

    @Override
    public List<PathSegment> getPathComponents() {
        ArrayList<PathSegment> components = new ArrayList<PathSegment>();
        Resource parent = this.getParent();
        if (parent != null) {
            components.addAll(parent.getPathComponents());
        }
        components.addAll(this.pathComponents);
        return components;
    }

    public String getFullpath() {
        StringBuilder builder = new StringBuilder();
        for (PathSegment component : this.getPathComponents()) {
            builder.append('/').append(component.getValue());
        }
        return builder.toString();
    }

    public String getServletPattern() {
        StringBuilder builder = new StringBuilder();
        String fullPath = this.getFullpath();
        Matcher pathParamMatcher = CONTEXT_PARAM_PATTERN.matcher(fullPath);
        if (pathParamMatcher.find()) {
            builder.append(fullPath, 0, pathParamMatcher.start()).append("*");
        } else {
            builder.append(fullPath);
        }
        return builder.toString();
    }

    public String getSubpath() {
        return this.subpath;
    }

    public String getLabel() {
        return this.label;
    }

    public String getSlug() {
        String slug = "";
        Resource parent = this.parent;
        while (parent instanceof SubResource) {
            slug = parent.getSimpleName() + "_" + slug;
            parent = parent.getParent();
        }
        slug = slug + this.getSimpleName();
        return slug;
    }

    public String getCustomParameterName() {
        return this.customParameterName;
    }

    public Resource getParent() {
        return this.parent;
    }

    public Set<MediaType> getConsumesMediaTypes() {
        return this.consumesMediaTypes;
    }

    public Set<MediaType> getProducesMediaTypes() {
        return this.producesMediaTypes;
    }

    public Set<ResourceParameter> getResourceParameters() {
        TreeSet<ResourceParameter> resourceParams = new TreeSet<ResourceParameter>(this.resourceParameters);
        resourceParams.addAll(this.getParent().getResourceParameters());
        return resourceParams;
    }

    public ResourceEntityParameter getEntityParameter() {
        return this.entityParameter;
    }

    public ResourceRepresentationMetadata getRepresentationMetadata() {
        return this.representationMetadata;
    }

    public List<? extends ResponseCode> getStatusCodes() {
        return this.statusCodes;
    }

    public List<? extends ResponseCode> getWarnings() {
        return this.warnings;
    }

    public Map<String, Object> getMetaData() {
        return Collections.unmodifiableMap(this.metaData);
    }

    public void putMetaData(String name, Object data) {
        this.metaData.put(name, data);
    }

    public Map<String, String> getResponseHeaders() {
        return this.responseHeaders;
    }

    public Set<Facet> getFacets() {
        return this.facets;
    }

    public Set<String> getSecurityRoles() {
        Resource parent;
        TreeSet<String> roles = new TreeSet<String>();
        RolesAllowed rolesAllowed = (RolesAllowed)this.getAnnotation(RolesAllowed.class);
        if (rolesAllowed != null) {
            Collections.addAll(roles, rolesAllowed.value());
        }
        if ((parent = this.getParent()) != null) {
            roles.addAll(parent.getSecurityRoles());
        }
        return roles;
    }
}

