/*
 * Decompiled with CFR 0.152.
 */
package com.webcohesion.enunciate.modules.jaxrs.api.impl;

import com.webcohesion.enunciate.api.datatype.Syntax;
import com.webcohesion.enunciate.api.resources.Entity;
import com.webcohesion.enunciate.api.resources.MediaTypeDescriptor;
import com.webcohesion.enunciate.javac.decorations.type.DecoratedTypeMirror;
import com.webcohesion.enunciate.javac.javadoc.DefaultJavaDocTagHandler;
import com.webcohesion.enunciate.javac.javadoc.JavaDoc;
import com.webcohesion.enunciate.javac.javadoc.JavaDocTagHandler;
import com.webcohesion.enunciate.modules.jaxrs.api.impl.CustomMediaTypeDescriptor;
import com.webcohesion.enunciate.modules.jaxrs.model.ResourceMethod;
import com.webcohesion.enunciate.modules.jaxrs.model.ResourceRepresentationMetadata;
import com.webcohesion.enunciate.modules.jaxrs.model.util.MediaType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;

public class ResponseEntityImpl
implements Entity {
    private ResourceMethod resourceMethod;
    private ResourceRepresentationMetadata responseMetadata;

    public ResponseEntityImpl(ResourceMethod resourceMethod, ResourceRepresentationMetadata responseMetadata) {
        this.resourceMethod = resourceMethod;
        this.responseMetadata = responseMetadata;
    }

    public String getDescription() {
        return this.responseMetadata.getDocValue();
    }

    public List<? extends MediaTypeDescriptor> getMediaTypes() {
        Set<MediaType> produces = this.resourceMethod.getProducesMediaTypes();
        ArrayList<MediaTypeDescriptor> mts = new ArrayList<MediaTypeDescriptor>(produces.size());
        for (MediaType mt : produces) {
            boolean descriptorFound = false;
            DecoratedTypeMirror type = (DecoratedTypeMirror)this.responseMetadata.getDelegate();
            for (Syntax syntax : this.resourceMethod.getContext().getContext().getApiRegistry().getSyntaxes()) {
                MediaTypeDescriptor descriptor = syntax.findMediaTypeDescriptor(mt.getMediaType(), type, mt.getQualityOfSource());
                if (descriptor == null) continue;
                mts.add(descriptor);
                descriptorFound = true;
            }
            if (descriptorFound) continue;
            mts.add(new CustomMediaTypeDescriptor(mt.getMediaType(), mt.getQualityOfSource()));
        }
        return mts;
    }

    public Map<String, AnnotationMirror> getAnnotations() {
        return Collections.emptyMap();
    }

    public JavaDoc getJavaDoc() {
        return new JavaDoc(null, (JavaDocTagHandler)new DefaultJavaDocTagHandler());
    }
}

