/*
 * Decompiled with CFR 0.152.
 */
package com.webcohesion.enunciate.modules.jaxrs.api.impl;

import com.webcohesion.enunciate.api.datatype.Syntax;
import com.webcohesion.enunciate.api.resources.Entity;
import com.webcohesion.enunciate.api.resources.MediaTypeDescriptor;
import com.webcohesion.enunciate.javac.decorations.type.DecoratedTypeMirror;
import com.webcohesion.enunciate.javac.javadoc.JavaDoc;
import com.webcohesion.enunciate.modules.jaxrs.api.impl.CustomMediaTypeDescriptor;
import com.webcohesion.enunciate.modules.jaxrs.model.ResourceEntityParameter;
import com.webcohesion.enunciate.modules.jaxrs.model.ResourceMethod;
import com.webcohesion.enunciate.modules.jaxrs.model.util.MediaType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;

public class RequestEntityImpl
implements Entity {
    private final ResourceMethod resourceMethod;
    private final ResourceEntityParameter entityParameter;

    public RequestEntityImpl(ResourceMethod resourceMethod, ResourceEntityParameter entityParameter) {
        this.resourceMethod = resourceMethod;
        this.entityParameter = entityParameter;
    }

    public String getDescription() {
        return this.entityParameter == null ? null : this.entityParameter.getDocValue();
    }

    public List<? extends MediaTypeDescriptor> getMediaTypes() {
        Set<MediaType> consumes = this.resourceMethod.getConsumesMediaTypes();
        ArrayList<MediaTypeDescriptor> mts = new ArrayList<MediaTypeDescriptor>(consumes.size());
        for (MediaType mt : consumes) {
            boolean descriptorFound = false;
            if (this.entityParameter != null) {
                DecoratedTypeMirror type = (DecoratedTypeMirror)this.entityParameter.getType();
                for (Syntax syntax : this.resourceMethod.getContext().getContext().getApiRegistry().getSyntaxes()) {
                    MediaTypeDescriptor descriptor = syntax.findMediaTypeDescriptor(mt.getMediaType(), type, mt.getQualityOfSource());
                    if (descriptor == null) continue;
                    mts.add(descriptor);
                    descriptorFound = true;
                }
            }
            if (descriptorFound) continue;
            mts.add(new CustomMediaTypeDescriptor(mt.getMediaType(), mt.getQualityOfSource()));
        }
        return mts;
    }

    public Map<String, AnnotationMirror> getAnnotations() {
        return this.entityParameter == null ? Collections.emptyMap() : this.entityParameter.getAnnotations();
    }

    public JavaDoc getJavaDoc() {
        return this.entityParameter == null ? null : this.entityParameter.getJavaDoc();
    }
}

