/*
 * Decompiled with CFR 0.152.
 */
package com.webcohesion.enunciate.modules.jaxrs;

import com.webcohesion.enunciate.EnunciateContext;
import com.webcohesion.enunciate.EnunciateException;
import com.webcohesion.enunciate.api.ApiRegistry;
import com.webcohesion.enunciate.artifacts.Artifact;
import com.webcohesion.enunciate.javac.decorations.type.DecoratedTypeMirror;
import com.webcohesion.enunciate.module.ApiFeatureProviderModule;
import com.webcohesion.enunciate.module.ApiRegistryProviderModule;
import com.webcohesion.enunciate.module.BasicEnunicateModule;
import com.webcohesion.enunciate.module.DependencySpec;
import com.webcohesion.enunciate.module.EnunciateModule;
import com.webcohesion.enunciate.module.MediaTypeDefinitionModule;
import com.webcohesion.enunciate.module.TypeFilteringModule;
import com.webcohesion.enunciate.modules.jaxrs.EnunciateJaxrsContext;
import com.webcohesion.enunciate.modules.jaxrs.JaxrsProviderClassListArtifact;
import com.webcohesion.enunciate.modules.jaxrs.JaxrsRootResourceClassListArtifact;
import com.webcohesion.enunciate.modules.jaxrs.model.ResourceEntityParameter;
import com.webcohesion.enunciate.modules.jaxrs.model.ResourceMethod;
import com.webcohesion.enunciate.modules.jaxrs.model.ResourceRepresentationMetadata;
import com.webcohesion.enunciate.modules.jaxrs.model.ResponseCode;
import com.webcohesion.enunciate.modules.jaxrs.model.RootResource;
import com.webcohesion.enunciate.modules.jaxrs.model.util.MediaType;
import com.webcohesion.enunciate.util.IgnoreUtils;
import com.webcohesion.enunciate.util.PathSortStrategy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.ws.rs.ApplicationPath;
import javax.ws.rs.Path;
import javax.ws.rs.ext.Provider;
import org.reflections.adapters.MetadataAdapter;

public class JaxrsModule
extends BasicEnunicateModule
implements TypeFilteringModule,
ApiRegistryProviderModule,
ApiFeatureProviderModule {
    private ApiRegistryProviderModule.DataTypeDetectionStrategy defaultDataTypeDetectionStrategy;
    private final List<MediaTypeDefinitionModule> mediaTypeModules = new ArrayList<MediaTypeDefinitionModule>();
    private ApiRegistry apiRegistry;
    private EnunciateJaxrsContext jaxrsContext;
    static final String NAME = "jaxrs";
    private PathSortStrategy defaultSortStrategy = PathSortStrategy.breadth_first;

    public String getName() {
        return NAME;
    }

    public List<DependencySpec> getDependencySpecifications() {
        return Collections.singletonList(new MediaTypeDependencySpec());
    }

    public ApiRegistryProviderModule.DataTypeDetectionStrategy getDataTypeDetectionStrategy() {
        String dataTypeDetection = this.config.getString("[@datatype-detection]", null);
        if (dataTypeDetection != null) {
            try {
                return ApiRegistryProviderModule.DataTypeDetectionStrategy.valueOf((String)dataTypeDetection);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if (this.defaultDataTypeDetectionStrategy != null) {
            return this.defaultDataTypeDetectionStrategy;
        }
        if (this.enunciate.getIncludePatterns().isEmpty()) {
            return ApiRegistryProviderModule.DataTypeDetectionStrategy.local;
        }
        return ApiRegistryProviderModule.DataTypeDetectionStrategy.aggressive;
    }

    public void setDefaultDataTypeDetectionStrategy(ApiRegistryProviderModule.DataTypeDetectionStrategy strategy) {
        this.defaultDataTypeDetectionStrategy = strategy;
    }

    public PathSortStrategy getPathSortStrategy() {
        PathSortStrategy strategy = this.defaultSortStrategy;
        try {
            strategy = PathSortStrategy.valueOf((String)this.config.getString("[@path-sort-strategy]", this.defaultSortStrategy.name()));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return strategy;
    }

    public void setDefaultSortStrategy(PathSortStrategy defaultSortStrategy) {
        this.defaultSortStrategy = defaultSortStrategy;
    }

    public void setApiRegistry(ApiRegistry registry) {
        this.apiRegistry = registry;
    }

    public EnunciateJaxrsContext getJaxrsContext() {
        return this.jaxrsContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void call(EnunciateContext context) {
        this.jaxrsContext = new EnunciateJaxrsContext(context);
        ApiRegistryProviderModule.DataTypeDetectionStrategy detectionStrategy = this.getDataTypeDetectionStrategy();
        String relativeContextPath = "";
        if (detectionStrategy != ApiRegistryProviderModule.DataTypeDetectionStrategy.passive) {
            Set elements = detectionStrategy == ApiRegistryProviderModule.DataTypeDetectionStrategy.local ? context.getLocalApiElements() : context.getApiElements();
            for (Element declaration : elements) {
                ApplicationPath applicationPathInfo;
                Provider providerInfo;
                TypeElement element;
                if (!(declaration instanceof TypeElement) || "org.glassfish.jersey.server.wadl.internal.WadlResource".equals((element = (TypeElement)declaration).getQualifiedName().toString()) || IgnoreUtils.isIgnored((Element)declaration)) continue;
                Path pathInfo = declaration.getAnnotation(Path.class);
                if (pathInfo != null) {
                    RootResource rootResource = new RootResource(element, this.jaxrsContext);
                    this.jaxrsContext.add(rootResource);
                    LinkedList<Element> contextStack = new LinkedList<Element>();
                    contextStack.push((Element)((Object)rootResource));
                    try {
                        for (ResourceMethod resourceMethod : rootResource.getResourceMethods(true)) {
                            this.addReferencedDataTypeDefinitions(resourceMethod, contextStack);
                        }
                    }
                    finally {
                        contextStack.pop();
                    }
                }
                if ((providerInfo = declaration.getAnnotation(Provider.class)) != null) {
                    this.jaxrsContext.addJAXRSProvider(element);
                }
                if ((applicationPathInfo = declaration.getAnnotation(ApplicationPath.class)) == null) continue;
                relativeContextPath = applicationPathInfo.value();
            }
        }
        relativeContextPath = this.config.getString("application[@path]", relativeContextPath);
        relativeContextPath = JaxrsModule.sanitizeContextPath(relativeContextPath);
        this.jaxrsContext.setRelativeContextPath(relativeContextPath);
        this.jaxrsContext.setGroupingStrategy(this.getGroupingStrategy());
        this.jaxrsContext.setPathSortStrategy(this.getPathSortStrategy());
        if (this.jaxrsContext.getRootResources().size() > 0) {
            this.enunciate.addArtifact((Artifact)new JaxrsRootResourceClassListArtifact(this.jaxrsContext));
            this.apiRegistry.getResourceApis().add(this.jaxrsContext);
        }
        if (this.jaxrsContext.getProviders().size() > 0) {
            this.enunciate.addArtifact((Artifact)new JaxrsProviderClassListArtifact(this.jaxrsContext));
        }
    }

    public static String sanitizeContextPath(String relativeContextPath) {
        while (relativeContextPath.startsWith("/")) {
            relativeContextPath = relativeContextPath.substring(1);
        }
        while (relativeContextPath.endsWith("/")) {
            relativeContextPath = relativeContextPath.substring(0, relativeContextPath.length() - 1);
        }
        return relativeContextPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addReferencedDataTypeDefinitions(ResourceMethod resourceMethod, LinkedList<Element> contextStack) {
        List<? extends ResponseCode> statusCodes;
        ResourceRepresentationMetadata outputPayload;
        if (IgnoreUtils.isIgnored((Element)((Object)resourceMethod))) {
            return;
        }
        ResourceEntityParameter ep = resourceMethod.getEntityParameter();
        if (ep != null) {
            Set<MediaType> consumesMt = resourceMethod.getConsumesMediaTypes();
            TreeSet<String> consumes = new TreeSet<String>();
            for (MediaType mediaType : consumesMt) {
                consumes.add(mediaType.getMediaType());
            }
            contextStack.push(ep.getDelegate());
            TypeMirror type = ep.getType();
            contextStack.push((Element)((Object)resourceMethod));
            try {
                for (MediaTypeDefinitionModule mediaTypeModule : this.mediaTypeModules) {
                    mediaTypeModule.addDataTypeDefinitions(type, consumes, contextStack);
                }
            }
            finally {
                contextStack.pop();
            }
        }
        if ((outputPayload = resourceMethod.getRepresentationMetadata()) != null) {
            TypeMirror type = outputPayload.getDelegate();
            Set<MediaType> producesMt = resourceMethod.getProducesMediaTypes();
            TreeSet<String> treeSet = new TreeSet<String>();
            for (MediaType mediaType : producesMt) {
                treeSet.add(mediaType.getMediaType());
            }
            contextStack.push((Element)((Object)resourceMethod));
            try {
                for (MediaTypeDefinitionModule mediaTypeModule : this.mediaTypeModules) {
                    mediaTypeModule.addDataTypeDefinitions(type, treeSet, contextStack);
                }
            }
            finally {
                contextStack.pop();
            }
        }
        if ((statusCodes = resourceMethod.getStatusCodes()) != null) {
            for (ResponseCode responseCode : statusCodes) {
                DecoratedTypeMirror type = responseCode.getType();
                if (type == null) continue;
                Set<MediaType> producesMt = resourceMethod.getProducesMediaTypes();
                TreeSet<String> produces = new TreeSet<String>();
                for (MediaType mediaType : producesMt) {
                    produces.add(mediaType.getMediaType());
                }
                contextStack.push((Element)((Object)resourceMethod));
                try {
                    for (MediaTypeDefinitionModule mediaTypeModule : this.mediaTypeModules) {
                        mediaTypeModule.addDataTypeDefinitions((TypeMirror)type, produces, contextStack);
                    }
                }
                finally {
                    contextStack.pop();
                }
            }
        }
    }

    public EnunciateJaxrsContext.GroupingStrategy getGroupingStrategy() {
        String groupBy = this.config.getString("[@groupBy]", "class");
        if ("class".equals(groupBy)) {
            return EnunciateJaxrsContext.GroupingStrategy.resource_class;
        }
        if ("path".equals(groupBy)) {
            return EnunciateJaxrsContext.GroupingStrategy.path;
        }
        if ("annotation".equals(groupBy)) {
            return EnunciateJaxrsContext.GroupingStrategy.annotation;
        }
        throw new EnunciateException("Unknown grouping strategy: " + groupBy);
    }

    public boolean acceptType(Object type, MetadataAdapter metadata) {
        List classAnnotations = metadata.getClassAnnotationNames(type);
        if (classAnnotations != null) {
            for (String classAnnotation : classAnnotations) {
                if (!Path.class.getName().equals(classAnnotation) && !Provider.class.getName().equals(classAnnotation) && !ApplicationPath.class.getName().equals(classAnnotation)) continue;
                return true;
            }
        }
        return false;
    }

    public class MediaTypeDependencySpec
    implements DependencySpec {
        public boolean accept(EnunciateModule module) {
            if (module instanceof MediaTypeDefinitionModule) {
                MediaTypeDefinitionModule definitionModule = (MediaTypeDefinitionModule)module;
                JaxrsModule.this.mediaTypeModules.add(definitionModule);
                definitionModule.setDefaultDataTypeDetectionStrategy(ApiRegistryProviderModule.DataTypeDetectionStrategy.passive);
                return true;
            }
            return false;
        }

        public boolean isFulfilled() {
            return true;
        }

        public String toString() {
            return "media type definition modules";
        }
    }
}

