/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.update;

import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.engine.binding.BindingUtils;
import com.hp.hpl.jena.sparql.modify.UpdateProcessorFactory;
import com.hp.hpl.jena.sparql.modify.UpdateProcessorRegistry;
import com.hp.hpl.jena.sparql.modify.lang.ParserSPARQLUpdate;
import com.hp.hpl.jena.sparql.modify.op.Update;
import com.hp.hpl.jena.update.GraphStore;
import com.hp.hpl.jena.update.UpdateException;
import com.hp.hpl.jena.update.UpdateProcessor;
import com.hp.hpl.jena.update.UpdateRequest;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.Reader;

public class UpdateFactory {
    public static UpdateRequest create() {
        return new UpdateRequest();
    }

    public static UpdateRequest create(String str2) {
        ParserSPARQLUpdate p = new ParserSPARQLUpdate();
        UpdateRequest update = new UpdateRequest();
        p.parse(update, str2);
        return update;
    }

    public static UpdateRequest read(String fileName) {
        InputStream in = null;
        if (fileName.equals("-")) {
            in = System.in;
        } else {
            try {
                in = new FileInputStream(fileName);
            }
            catch (FileNotFoundException ex) {
                throw new UpdateException("File not found: " + fileName);
            }
        }
        return UpdateFactory.read(in);
    }

    public static UpdateRequest read(InputStream in) {
        ParserSPARQLUpdate p = new ParserSPARQLUpdate();
        UpdateRequest update = new UpdateRequest();
        p.parse(update, in);
        return update;
    }

    private static UpdateRequest read(Reader in) {
        ParserSPARQLUpdate p = new ParserSPARQLUpdate();
        UpdateRequest update = new UpdateRequest();
        p.parse(update, in);
        return update;
    }

    public static UpdateProcessor create(Update update, GraphStore graphStore) {
        return UpdateFactory.create(update, graphStore, (Binding)null);
    }

    public static UpdateProcessor create(Update update, GraphStore graphStore, QuerySolution initialSolution) {
        Binding b = null;
        if (initialSolution != null) {
            b = BindingUtils.asBinding(initialSolution);
        }
        return UpdateFactory.create(update, graphStore, b);
    }

    public static UpdateProcessor create(Update update, GraphStore graphStore, Binding initialBinding) {
        return UpdateFactory.create(new UpdateRequest(update), graphStore, initialBinding);
    }

    public static UpdateProcessor create(UpdateRequest updateRequest, GraphStore graphStore) {
        return UpdateFactory.create(updateRequest, graphStore, (Binding)null);
    }

    public static UpdateProcessor create(UpdateRequest updateRequest, GraphStore graphStore, QuerySolution initialSolution) {
        Binding b = null;
        if (initialSolution != null) {
            b = BindingUtils.asBinding(initialSolution);
        }
        return UpdateFactory.create(updateRequest, graphStore, b);
    }

    public static UpdateProcessor create(UpdateRequest updateRequest, GraphStore graphStore, Binding initialBinding) {
        UpdateProcessorFactory f = UpdateProcessorRegistry.get().find(updateRequest, graphStore);
        if (f == null) {
            return null;
        }
        UpdateProcessor uProc = f.create(updateRequest, graphStore, initialBinding);
        return uProc;
    }
}

