/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.update;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.sparql.core.DataSourceGraphImpl;
import com.hp.hpl.jena.sparql.core.DataSourceImpl;
import com.hp.hpl.jena.sparql.core.DatasetImpl;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.modify.op.Update;
import com.hp.hpl.jena.sparql.util.graph.GraphUtils;
import com.hp.hpl.jena.update.GraphStore;
import com.hp.hpl.jena.update.UpdateException;
import com.hp.hpl.jena.update.UpdateFactory;
import com.hp.hpl.jena.update.UpdateRequest;
import java.util.Iterator;

public class GraphStoreFactory {
    public static GraphStore create() {
        return new GraphStoreBasic();
    }

    public static GraphStore create(Model model) {
        return new GraphStoreBasic(model.getGraph());
    }

    public static GraphStore create(Graph graph) {
        return new GraphStoreBasic(graph);
    }

    public static GraphStore create(Dataset dataset) {
        if (dataset instanceof DatasetImpl || dataset instanceof DataSourceImpl) {
            return new GraphStoreBasic(dataset);
        }
        throw new UpdateException("Can't create a GraphStore for dataset: " + dataset);
    }

    public static class GraphStoreBasic
    extends DataSourceGraphImpl
    implements GraphStore {
        public GraphStoreBasic() {
            super.setDefaultGraph(GraphUtils.makeDefaultGraph());
        }

        public GraphStoreBasic(Dataset ds) {
            super(ds);
        }

        public GraphStoreBasic(Graph graph) {
            super(graph);
        }

        public void execute(UpdateRequest request, Binding binding) {
            UpdateFactory.create(request, (GraphStore)this, binding);
        }

        public void execute(UpdateRequest request) {
            UpdateFactory.create(request, (GraphStore)this);
        }

        public void execute(Update graphUpdate, Binding binding) {
            UpdateFactory.create(graphUpdate, (GraphStore)this, binding);
        }

        public void execute(Update graphUpdate) {
            UpdateFactory.create(graphUpdate, (GraphStore)this);
        }

        public Dataset toDataset() {
            return new DataSourceImpl(this);
        }

        public void close() {
            Iterator iter = this.listGraphNodes();
            while (iter.hasNext()) {
                Node n = (Node)iter.next();
                this.getGraph(n).close();
            }
        }

        public void sync() {
        }
    }
}

