/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.syntax;

import com.hp.hpl.jena.sparql.syntax.Element;
import com.hp.hpl.jena.sparql.syntax.ElementAssign;
import com.hp.hpl.jena.sparql.syntax.ElementDataset;
import com.hp.hpl.jena.sparql.syntax.ElementFilter;
import com.hp.hpl.jena.sparql.syntax.ElementGroup;
import com.hp.hpl.jena.sparql.syntax.ElementNamedGraph;
import com.hp.hpl.jena.sparql.syntax.ElementOptional;
import com.hp.hpl.jena.sparql.syntax.ElementService;
import com.hp.hpl.jena.sparql.syntax.ElementSubQuery;
import com.hp.hpl.jena.sparql.syntax.ElementTriplesBlock;
import com.hp.hpl.jena.sparql.syntax.ElementUnion;
import com.hp.hpl.jena.sparql.syntax.ElementUnsaid;
import com.hp.hpl.jena.sparql.syntax.ElementVisitor;
import java.util.Iterator;
import java.util.ListIterator;

public class ElementWalker {
    public static void walk(Element el, ElementVisitor visitor) {
        el.visit(new Walker(visitor));
    }

    protected static class Walker
    implements ElementVisitor {
        protected ElementVisitor proc;

        protected Walker(ElementVisitor visitor) {
            this.proc = visitor;
        }

        public void visit(ElementTriplesBlock el) {
            this.proc.visit(el);
        }

        public void visit(ElementFilter el) {
            this.proc.visit(el);
        }

        public void visit(ElementAssign el) {
            this.proc.visit(el);
        }

        public void visit(ElementUnion el) {
            ListIterator iter = el.getElements().listIterator();
            while (iter.hasNext()) {
                Element e2 = (Element)iter.next();
                e2.visit(this);
            }
            this.proc.visit(el);
        }

        public void visit(ElementGroup el) {
            Iterator iter = el.getElements().iterator();
            while (iter.hasNext()) {
                Element e2 = (Element)iter.next();
                e2.visit(this);
            }
            this.proc.visit(el);
        }

        public void visit(ElementOptional el) {
            if (el.getOptionalElement() != null) {
                el.getOptionalElement().visit(this);
            }
            this.proc.visit(el);
        }

        public void visit(ElementDataset el) {
            if (el.getPatternElement() != null) {
                el.getPatternElement().visit(this);
            }
            this.proc.visit(el);
        }

        public void visit(ElementNamedGraph el) {
            if (el.getElement() != null) {
                el.getElement().visit(this);
            }
            this.proc.visit(el);
        }

        public void visit(ElementService el) {
            if (el.getElement() != null) {
                el.getElement().visit(this);
            }
            this.proc.visit(el);
        }

        public void visit(ElementUnsaid el) {
            if (el.getElement() != null) {
                el.getElement().visit(this);
            }
            this.proc.visit(el);
        }

        public void visit(ElementSubQuery el) {
            this.proc.visit(el);
        }
    }
}

