/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.suites;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.AlreadyExists;
import com.hp.hpl.jena.sparql.DoesNotExist;
import com.hp.hpl.jena.sparql.modify.op.GraphMgt;
import com.hp.hpl.jena.sparql.modify.op.Update;
import com.hp.hpl.jena.sparql.modify.op.UpdateCreate;
import com.hp.hpl.jena.sparql.modify.op.UpdateDrop;
import com.hp.hpl.jena.sparql.suites.TestUpdateBase;
import com.hp.hpl.jena.sparql.util.graph.GraphUtils;
import com.hp.hpl.jena.update.GraphStore;
import com.hp.hpl.jena.update.GraphStoreFactory;
import com.hp.hpl.jena.update.UpdateAction;

public abstract class TestUpdateGraphMgt
extends TestUpdateBase {
    static final Node graphIRI = Node.createURI((String)"http://example/graph");

    public void testCreateDrop1() {
        GraphStore gStore = GraphStoreFactory.create();
        GraphMgt u = new UpdateCreate(graphIRI);
        UpdateAction.execute((Update)u, gStore);
        TestUpdateGraphMgt.assertTrue((boolean)gStore.containsGraph(graphIRI));
        TestUpdateGraphMgt.assertTrue((boolean)TestUpdateGraphMgt.graphEmpty(gStore.getGraph(graphIRI)));
        try {
            UpdateAction.execute((Update)u, gStore);
            TestUpdateGraphMgt.fail();
        }
        catch (AlreadyExists ex) {
            // empty catch block
        }
        u = new UpdateDrop(graphIRI);
        UpdateAction.execute((Update)u, gStore);
        TestUpdateGraphMgt.assertFalse((boolean)gStore.containsGraph(graphIRI));
        try {
            UpdateAction.execute((Update)u, gStore);
            TestUpdateGraphMgt.fail();
        }
        catch (DoesNotExist doesNotExist) {
            // empty catch block
        }
    }

    public void testCreateDrop2() {
        GraphStore gStore = GraphStoreFactory.create();
        GraphMgt u = new UpdateCreate(graphIRI);
        UpdateAction.execute((Update)u, gStore);
        u = new UpdateCreate(graphIRI, true);
        UpdateAction.execute((Update)u, gStore);
        TestUpdateGraphMgt.assertTrue((boolean)gStore.containsGraph(graphIRI));
        TestUpdateGraphMgt.assertTrue((boolean)TestUpdateGraphMgt.graphEmpty(gStore.getGraph(graphIRI)));
        u = new UpdateDrop(graphIRI);
        UpdateAction.execute((Update)u, gStore);
        TestUpdateGraphMgt.assertFalse((boolean)gStore.containsGraph(graphIRI));
        u = new UpdateDrop(graphIRI, true);
        UpdateAction.execute((Update)u, gStore);
    }

    public void testCreateDrop3() {
        GraphStore gStore = GraphStoreFactory.create();
        TestUpdateGraphMgt.script(gStore, "create-1.rup");
        TestUpdateGraphMgt.assertTrue((boolean)gStore.containsGraph(graphIRI));
        TestUpdateGraphMgt.assertTrue((boolean)TestUpdateGraphMgt.graphEmpty(gStore.getGraph(graphIRI)));
    }

    public void testCreateDrop4() {
        GraphStore gStore = GraphStoreFactory.create();
        gStore.addGraph(graphIRI, GraphUtils.makeDefaultGraph());
        TestUpdateGraphMgt.script(gStore, "drop-1.rup");
        TestUpdateGraphMgt.assertFalse((boolean)gStore.containsGraph(graphIRI));
    }
}

