/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.suites;

import com.hp.hpl.jena.graph.Factory;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.engine.binding.Binding1;
import com.hp.hpl.jena.sparql.modify.op.Update;
import com.hp.hpl.jena.sparql.modify.op.UpdateDelete;
import com.hp.hpl.jena.sparql.modify.op.UpdateDeleteData;
import com.hp.hpl.jena.sparql.modify.op.UpdateInsert;
import com.hp.hpl.jena.sparql.modify.op.UpdateInsertData;
import com.hp.hpl.jena.sparql.modify.op.UpdateModify;
import com.hp.hpl.jena.sparql.suites.TestUpdateBase;
import com.hp.hpl.jena.sparql.syntax.Element;
import com.hp.hpl.jena.sparql.syntax.Template;
import com.hp.hpl.jena.sparql.syntax.TemplateGroup;
import com.hp.hpl.jena.sparql.syntax.TemplateTriple;
import com.hp.hpl.jena.sparql.util.NodeFactory;
import com.hp.hpl.jena.update.GraphStore;
import com.hp.hpl.jena.update.UpdateAction;
import com.hp.hpl.jena.update.UpdateFactory;
import com.hp.hpl.jena.update.UpdateProcessor;
import com.hp.hpl.jena.update.UpdateRequest;

public abstract class TestUpdateGraph
extends TestUpdateBase {
    protected static Node s = NodeFactory.create("<http://example/r>");
    protected static Node p = NodeFactory.create("<http://example/p>");
    protected static Node o1 = NodeFactory.create("2007");
    protected static Triple triple1 = new Triple(s, p, o1);
    protected static Node o2 = NodeFactory.create("1066");
    protected static Triple triple2 = new Triple(s, p, o2);
    protected static Graph graph1 = TestUpdateGraph.data1();
    protected static Node graphIRI = NodeFactory.create("<http://example/graph>");

    public void testInsertData1() {
        GraphStore gStore = this.getEmptyGraphStore();
        this.defaultGraphData(gStore, graph1);
        UpdateInsertData insert = new UpdateInsertData();
        insert.setData(TestUpdateGraph.data2());
        UpdateProcessor uProc = UpdateFactory.create(insert, gStore);
        uProc.execute();
        TestUpdateGraph.assertFalse((boolean)TestUpdateGraph.graphEmpty(gStore.getDefaultGraph()));
        TestUpdateGraph.assertTrue((boolean)TestUpdateGraph.graphContains(gStore.getDefaultGraph(), triple1));
        TestUpdateGraph.assertTrue((boolean)TestUpdateGraph.graphContains(gStore.getDefaultGraph(), triple2));
    }

    public void testDeleteData1() {
        GraphStore gStore = this.getEmptyGraphStore();
        this.defaultGraphData(gStore, graph1);
        UpdateDeleteData delete = new UpdateDeleteData();
        delete.setData(TestUpdateGraph.data2());
        UpdateProcessor uProc = UpdateFactory.create(delete, gStore);
        uProc.execute();
        TestUpdateGraph.assertFalse((boolean)TestUpdateGraph.graphEmpty(gStore.getDefaultGraph()));
        TestUpdateGraph.assertTrue((boolean)TestUpdateGraph.graphContains(gStore.getDefaultGraph(), triple1));
        TestUpdateGraph.assertFalse((boolean)TestUpdateGraph.graphContains(gStore.getDefaultGraph(), triple2));
    }

    public void testDeleteData2() {
        GraphStore gStore = this.getEmptyGraphStore();
        this.defaultGraphData(gStore, graph1);
        UpdateDeleteData delete = new UpdateDeleteData();
        delete.setData(TestUpdateGraph.data1());
        UpdateProcessor uProc = UpdateFactory.create(delete, gStore);
        uProc.execute();
        TestUpdateGraph.assertTrue((boolean)TestUpdateGraph.graphEmpty(gStore.getDefaultGraph()));
        TestUpdateGraph.assertFalse((boolean)TestUpdateGraph.graphContains(gStore.getDefaultGraph(), triple1));
    }

    public void testInsert1() {
        GraphStore gStore = this.getEmptyGraphStore();
        UpdateInsert insert = new UpdateInsert();
        insert.setInsertTemplate(new TemplateGroup());
        UpdateAction.execute((Update)insert, gStore);
        TestUpdateGraph.assertTrue((boolean)TestUpdateGraph.graphEmpty(gStore.getDefaultGraph()));
    }

    public void testInsert2() {
        GraphStore gStore = this.getEmptyGraphStore();
        UpdateInsert insert = new UpdateInsert();
        insert.setInsertTemplate(new TemplateTriple(triple1));
        UpdateAction.execute((Update)insert, gStore);
        TestUpdateGraph.assertTrue((boolean)TestUpdateGraph.graphContains(gStore.getDefaultGraph(), triple1));
    }

    public void testInsert3() {
        GraphStore gStore = this.getEmptyGraphStore();
        UpdateInsert insert = new UpdateInsert(graph1);
        UpdateAction.execute((Update)insert, gStore);
        TestUpdateGraph.assertTrue((boolean)TestUpdateGraph.graphContains(gStore.getDefaultGraph(), triple1));
    }

    public void testInsert4() {
        GraphStore gStore = this.getEmptyGraphStore();
        gStore.addGraph(graphIRI, Factory.createDefaultGraph());
        UpdateInsert insert = new UpdateInsert(triple1);
        insert.addGraphName(graphIRI);
        UpdateAction.execute((Update)insert, gStore);
        TestUpdateGraph.assertTrue((boolean)TestUpdateGraph.graphContains(gStore.getGraph(graphIRI), triple1));
    }

    public void testInsert5() {
        GraphStore gStore = this.getEmptyGraphStore();
        this.defaultGraphData(gStore, graph1);
        Element element = QueryFactory.createElement("{ ?s <http://example/p> 2007 }");
        Template template = QueryFactory.createTemplate("{ ?s <http://example/p> 1066 }");
        UpdateInsert insert = new UpdateInsert();
        insert.setPattern(element);
        insert.setInsertTemplate(template);
        UpdateAction.execute((Update)insert, gStore);
        TestUpdateGraph.assertTrue((boolean)TestUpdateGraph.graphContains(gStore.getDefaultGraph(), triple2));
    }

    public void testDelete1() {
        GraphStore gStore = this.getEmptyGraphStore();
        UpdateDelete insert = new UpdateDelete();
        insert.setDeleteTemplate(new TemplateGroup());
        UpdateAction.execute((Update)insert, gStore);
        TestUpdateGraph.assertTrue((boolean)TestUpdateGraph.graphEmpty(gStore.getDefaultGraph()));
    }

    public void testDelete2() {
        GraphStore gStore = this.getEmptyGraphStore();
        this.defaultGraphData(gStore, graph1);
        UpdateDelete delete = new UpdateDelete();
        delete.setDeleteTemplate(new TemplateGroup());
        UpdateAction.execute((Update)delete, gStore);
        TestUpdateGraph.assertFalse((boolean)TestUpdateGraph.graphEmpty(gStore.getDefaultGraph()));
    }

    public void testDelete3() {
        GraphStore gStore = this.getEmptyGraphStore();
        this.defaultGraphData(gStore, graph1);
        UpdateDelete delete = new UpdateDelete(triple1);
        UpdateAction.execute((Update)delete, gStore);
        TestUpdateGraph.assertTrue((boolean)TestUpdateGraph.graphEmpty(gStore.getDefaultGraph()));
    }

    public void testDelete4() {
        GraphStore gStore = this.getEmptyGraphStore();
        this.namedGraphData(gStore, graphIRI, TestUpdateGraph.data1());
        UpdateDelete delete = new UpdateDelete(triple1);
        delete.addGraphName(graphIRI);
        UpdateAction.execute((Update)delete, gStore);
        TestUpdateGraph.assertTrue((boolean)TestUpdateGraph.graphEmpty(gStore.getGraph(graphIRI)));
        TestUpdateGraph.assertTrue((boolean)TestUpdateGraph.graphEmpty(gStore.getDefaultGraph()));
    }

    public void testDelete5() {
        GraphStore gStore = this.getEmptyGraphStore();
        this.defaultGraphData(gStore, TestUpdateGraph.data2());
        this.namedGraphData(gStore, graphIRI, TestUpdateGraph.data1());
        UpdateDelete delete = new UpdateDelete();
        delete.setPattern("{ ?s <http://example/p> ?o } ");
        delete.setDeleteTemplate("{ ?s <http://example/p> 2007 }");
        delete.addGraphName(graphIRI);
        UpdateAction.execute((Update)delete, gStore);
        TestUpdateGraph.assertTrue((boolean)TestUpdateGraph.graphEmpty(gStore.getGraph(graphIRI)));
        TestUpdateGraph.assertFalse((boolean)TestUpdateGraph.graphEmpty(gStore.getDefaultGraph()));
    }

    public void testModify1() {
        GraphStore gStore = this.getEmptyGraphStore();
        this.defaultGraphData(gStore, TestUpdateGraph.data2());
        this.namedGraphData(gStore, graphIRI, Factory.createDefaultGraph());
        UpdateModify modify = new UpdateModify();
        modify.addGraphName(graphIRI);
        modify.setPattern("{ ?s <http://example/p> ?o } ");
        modify.setDeleteTemplate("{ ?s <http://example/p> ?o}");
        modify.setInsertTemplate(new TemplateTriple(triple1));
        UpdateAction.execute((Update)modify, gStore);
        TestUpdateGraph.assertFalse((boolean)TestUpdateGraph.graphEmpty(gStore.getGraph(graphIRI)));
        TestUpdateGraph.assertFalse((boolean)TestUpdateGraph.graphEmpty(gStore.getDefaultGraph()));
        TestUpdateGraph.assertTrue((boolean)TestUpdateGraph.graphContains(gStore.getGraph(graphIRI), triple1));
    }

    public void testUpdateScript1() {
        GraphStore gStore = this.getEmptyGraphStore();
        TestUpdateGraph.script(gStore, "update-1.rup");
        TestUpdateGraph.assertTrue((boolean)TestUpdateGraph.graphContains(gStore.getDefaultGraph(), new Triple(s, p, NodeFactory.create("123"))));
    }

    public void testUpdateScript2() {
        GraphStore gStore = this.getEmptyGraphStore();
        TestUpdateGraph.script(gStore, "update-2.rup");
        TestUpdateGraph.assertTrue((boolean)TestUpdateGraph.graphContains(gStore.getGraph(Node.createURI((String)"http://example/g1")), new Triple(s, p, NodeFactory.create("123"))));
        TestUpdateGraph.assertTrue((boolean)TestUpdateGraph.graphEmpty(gStore.getDefaultGraph()));
    }

    public void testUpdateScript3() {
        GraphStore gStore = this.getEmptyGraphStore();
        TestUpdateGraph.script(gStore, "update-3.rup");
        TestUpdateGraph.assertTrue((boolean)TestUpdateGraph.graphEmpty(gStore.getGraph(Node.createURI((String)"http://example/g1"))));
        TestUpdateGraph.assertTrue((boolean)TestUpdateGraph.graphEmpty(gStore.getDefaultGraph()));
    }

    private Graph testUpdateInitialBindingWorker(Var v, Node n) {
        GraphStore gStore = this.getEmptyGraphStore();
        UpdateRequest req = UpdateFactory.create();
        UpdateInsert ins = new UpdateInsert();
        TemplateGroup template = new TemplateGroup();
        template.addTriple(triple1);
        template.addTriple(triple2);
        ins.setInsertTemplate(template);
        req.addUpdate(ins);
        UpdateDelete delete = new UpdateDelete();
        delete.setPattern("{ ?s <http://example/p> ?o } ");
        delete.setDeleteTemplate("{ ?s <http://example/p> ?o}");
        req.addUpdate(delete);
        Binding1 b = new Binding1(null, v, n);
        UpdateAction.execute(req, gStore, (Binding)b);
        return gStore.getDefaultGraph();
    }

    public void testUpdateInitialBinding1() {
        Graph graph = this.testUpdateInitialBindingWorker(Var.alloc("o"), o1);
        TestUpdateGraph.assertEquals((int)graph.size(), (int)1);
        TestUpdateGraph.assertFalse((boolean)TestUpdateGraph.graphContains(graph, triple1));
        TestUpdateGraph.assertTrue((boolean)TestUpdateGraph.graphContains(graph, triple2));
    }

    public void testUpdateInitialBinding2() {
        Graph graph = this.testUpdateInitialBindingWorker(Var.alloc("o"), o2);
        TestUpdateGraph.assertEquals((int)graph.size(), (int)1);
        TestUpdateGraph.assertTrue((boolean)TestUpdateGraph.graphContains(graph, triple1));
        TestUpdateGraph.assertFalse((boolean)TestUpdateGraph.graphContains(graph, triple2));
    }

    public void testUpdateInitialBinding3() {
        Graph graph = this.testUpdateInitialBindingWorker(Var.alloc("FF"), o1);
        TestUpdateGraph.assertTrue((boolean)TestUpdateGraph.graphEmpty(graph));
    }

    private static Graph data1() {
        Graph graph = Factory.createDefaultGraph();
        graph.add(triple1);
        return graph;
    }

    private static Graph data2() {
        Graph graph = Factory.createDefaultGraph();
        graph.add(triple2);
        return graph;
    }
}

