/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.suites;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.sparql.util.graph.GraphUtils;
import com.hp.hpl.jena.update.GraphStore;
import com.hp.hpl.jena.update.UpdateAction;
import junit.framework.TestCase;

public abstract class TestUpdateBase
extends TestCase {
    protected static final String FileBase = "testing/Update";

    protected abstract GraphStore getEmptyGraphStore();

    protected void defaultGraphData(GraphStore gStore, Graph data) {
        Graph g = gStore.getDefaultGraph();
        g.getBulkUpdateHandler().removeAll();
        g.getBulkUpdateHandler().add(data);
    }

    protected void namedGraphData(GraphStore gStore, Node uri, Graph data) {
        Graph g = gStore.getGraph(uri);
        if (g == null) {
            gStore.addGraph(uri, GraphUtils.makeJenaDefaultGraph());
            g = gStore.getGraph(uri);
        } else {
            g.getBulkUpdateHandler().removeAll();
        }
        g.getBulkUpdateHandler().add(data);
    }

    protected static void script(GraphStore gStore, String filename) {
        UpdateAction.readExecute("testing/Update/" + filename, gStore);
    }

    protected static boolean graphEmpty(Graph graph) {
        return graph.isEmpty();
    }

    protected static boolean graphContains(Graph graph, Triple triple) {
        return graph.contains(triple);
    }
}

