/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.serializer;

import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.sparql.core.BasicPattern;
import com.hp.hpl.jena.sparql.serializer.FormatterBase;
import com.hp.hpl.jena.sparql.serializer.FormatterTemplate;
import com.hp.hpl.jena.sparql.serializer.SerializationContext;
import com.hp.hpl.jena.sparql.syntax.Template;
import com.hp.hpl.jena.sparql.syntax.TemplateGroup;
import com.hp.hpl.jena.sparql.syntax.TemplateTriple;
import com.hp.hpl.jena.sparql.util.IndentedLineBuffer;
import com.hp.hpl.jena.sparql.util.IndentedWriter;
import java.util.Iterator;

public class FmtTemplate
extends FormatterBase
implements FormatterTemplate {
    public FmtTemplate(IndentedWriter out, SerializationContext context) {
        super(out, context);
    }

    public static void format(IndentedWriter out, SerializationContext cxt, Template template) {
        FmtTemplate fmt = new FmtTemplate(out, cxt);
        fmt.startVisit();
        template.visit(fmt);
        fmt.finishVisit();
    }

    public static String asString(Template template) {
        SerializationContext cxt = new SerializationContext();
        IndentedLineBuffer b = new IndentedLineBuffer();
        FmtTemplate.format(b.getIndentedWriter(), cxt, template);
        return b.toString();
    }

    public void visit(TemplateGroup template) {
        this.out.print("{");
        this.out.incIndent(2);
        this.out.pad();
        BasicPattern acc = new BasicPattern();
        Iterator iter = template.templates();
        while (iter.hasNext()) {
            Template temp = (Template)iter.next();
            if (temp instanceof TemplateTriple) {
                Triple triple = ((TemplateTriple)temp).getTriple();
                acc.add(triple);
                continue;
            }
            if (acc != null && !acc.isEmpty()) {
                this.formatTriples(acc);
            }
            acc = new BasicPattern();
            temp.visit(this);
            this.out.print(" .");
            this.out.newline();
        }
        if (acc != null && !acc.isEmpty()) {
            this.formatTriples(acc);
        }
        this.out.decIndent(2);
        this.out.print("}");
        this.out.newline();
    }

    public void visit(TemplateTriple template) {
        this.formatTriple(template.getTriple());
    }
}

