/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.pfunction.library;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.ARQInternalErrorException;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.engine.ExecutionContext;
import com.hp.hpl.jena.sparql.engine.QueryIterator;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.pfunction.library.ListBase1;
import com.hp.hpl.jena.sparql.procedure.ProcLib;
import com.hp.hpl.jena.sparql.util.NodeFactory;
import com.hp.hpl.jena.sparql.util.graph.GNode;
import com.hp.hpl.jena.sparql.util.graph.GraphList;

public class listLength
extends ListBase1 {
    public QueryIterator execOneList(Binding binding, Node listNode, Node predicate, Node length, ExecutionContext execCxt) {
        Graph graph = execCxt.getActiveGraph();
        if (Var.isVar(listNode)) {
            throw new ARQInternalErrorException("listLength: Subject is a variable");
        }
        if (Var.isVar(length)) {
            return this.length(binding, graph, listNode, Var.alloc(length), execCxt);
        }
        return this.verify(binding, graph, listNode, length, execCxt);
    }

    private QueryIterator length(Binding binding, Graph graph, Node listNode, Var varLength, ExecutionContext execCxt) {
        int x = GraphList.length(new GNode(graph, listNode));
        if (x < 0) {
            return ProcLib.noResults(execCxt);
        }
        Node n = NodeFactory.intToNode(x);
        return ProcLib.oneResult(binding, varLength, n, execCxt);
    }

    private QueryIterator verify(Binding binding, Graph graph, Node listNode, Node length, ExecutionContext execCxt) {
        int len;
        int x = GraphList.length(new GNode(graph, listNode));
        if (x == (len = NodeFactory.nodeToInt(length))) {
            return ProcLib.result(binding, execCxt);
        }
        return ProcLib.noResults(execCxt);
    }
}

