/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.pfunction.library;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.engine.ExecutionContext;
import com.hp.hpl.jena.sparql.engine.QueryIterator;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.engine.binding.BindingMap;
import com.hp.hpl.jena.sparql.engine.iterator.QueryIterPlainWrapper;
import com.hp.hpl.jena.sparql.expr.ExprEvalException;
import com.hp.hpl.jena.sparql.pfunction.PropFuncArg;
import com.hp.hpl.jena.sparql.pfunction.library.ListBaseList;
import com.hp.hpl.jena.sparql.procedure.ProcLib;
import com.hp.hpl.jena.sparql.util.NodeFactory;
import com.hp.hpl.jena.sparql.util.graph.GNode;
import com.hp.hpl.jena.sparql.util.graph.GraphList;
import java.util.ArrayList;
import java.util.List;

public class listIndex
extends ListBaseList {
    public QueryIterator execOneList(Binding binding, Node listNode, Node predicate, PropFuncArg object, ExecutionContext execCxt) {
        if (Var.isVar(listNode)) {
            throw new ExprEvalException("ListIndex : subject not a list or variable bound to a list");
        }
        if (object.getArgList().size() != 2) {
            throw new ExprEvalException("ListIndex : object not a list of length 2");
        }
        Node indexNode = object.getArg(0);
        Node memberNode = object.getArg(1);
        Graph graph = execCxt.getActiveGraph();
        if (Var.isVar(indexNode) && !Var.isVar(memberNode)) {
            return listIndex.findIndex(graph, binding, listNode, Var.alloc(indexNode), memberNode, execCxt);
        }
        if (!Var.isVar(indexNode) && Var.isVar(memberNode)) {
            return listIndex.getByIndex(graph, binding, listNode, indexNode, Var.alloc(memberNode), execCxt);
        }
        if (!Var.isVar(indexNode) && !Var.isVar(memberNode)) {
            return listIndex.testSlotValue(graph, binding, listNode, indexNode, memberNode, execCxt);
        }
        return listIndex.findIndexMember(graph, binding, listNode, Var.alloc(indexNode), Var.alloc(memberNode), execCxt);
    }

    private static QueryIterator getByIndex(Graph graph, Binding binding, Node listNode, Node indexNode, Var varMember, ExecutionContext execCxt) {
        int i = NodeFactory.nodeToInt(indexNode);
        if (i < 0) {
            return ProcLib.noResults(execCxt);
        }
        Node n = GraphList.get(new GNode(graph, listNode), i);
        if (n == null) {
            return ProcLib.noResults(execCxt);
        }
        return ProcLib.oneResult(binding, varMember, n, execCxt);
    }

    private static QueryIterator testSlotValue(Graph graph, Binding binding, Node listNode, Node indexNode, Node memberNode, ExecutionContext execCxt) {
        int i = NodeFactory.nodeToInt(indexNode);
        if (i < 0) {
            return ProcLib.noResults(execCxt);
        }
        Node n = GraphList.get(new GNode(graph, listNode), i);
        if (n == null) {
            return ProcLib.noResults(execCxt);
        }
        if (n.equals((Object)memberNode)) {
            return ProcLib.result(binding, execCxt);
        }
        return ProcLib.noResults(execCxt);
    }

    private static QueryIterator findIndex(Graph graph, Binding binding, Node listNode, Var var, Node member, ExecutionContext execCxt) {
        int i = GraphList.index(new GNode(graph, listNode), member);
        if (i < 0) {
            return ProcLib.noResults(execCxt);
        }
        Node idx = NodeFactory.intToNode(i);
        return ProcLib.oneResult(binding, var, idx, execCxt);
    }

    private static QueryIterator findIndexMember(Graph graph, Binding binding, Node listNode, Var varIndex, Var varMember, ExecutionContext execCxt) {
        List members = GraphList.members(new GNode(graph, listNode));
        ArrayList<BindingMap> bindings = new ArrayList<BindingMap>();
        for (int i = 0; i < members.size(); ++i) {
            Node idx = NodeFactory.intToNode(i);
            Node member = (Node)members.get(i);
            BindingMap b = new BindingMap(binding);
            b.add(varIndex, idx);
            b.add(varMember, member);
            bindings.add(b);
        }
        return new QueryIterPlainWrapper(bindings.iterator(), execCxt);
    }
}

