/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.pfunction.library;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.engine.ExecutionContext;
import com.hp.hpl.jena.sparql.engine.QueryIterator;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.engine.binding.Binding1;
import com.hp.hpl.jena.sparql.engine.iterator.QueryIterConcat;
import com.hp.hpl.jena.sparql.engine.iterator.QueryIterPlainWrapper;
import com.hp.hpl.jena.sparql.engine.iterator.QueryIterYieldN;
import com.hp.hpl.jena.sparql.pfunction.PFuncSimple;
import com.hp.hpl.jena.sparql.procedure.ProcLib;
import com.hp.hpl.jena.sparql.util.graph.GraphContainerUtils;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.vocabulary.RDF;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;

public class container
extends PFuncSimple {
    Node typeNode = null;

    public container() {
        this.typeNode = null;
    }

    protected container(Node typeURI) {
        this.typeNode = typeURI;
    }

    public QueryIterator execEvaluated(Binding binding, Node containerNode, Node predicate, Node member, ExecutionContext execCxt) {
        Graph graph = execCxt.getActiveGraph();
        if (!containerNode.isVariable()) {
            if (!GraphContainerUtils.isContainer(execCxt.getActiveGraph(), containerNode, this.typeNode)) {
                return ProcLib.noResults(execCxt);
            }
            return this.oneContainer(binding, containerNode, member, execCxt);
        }
        Collection c = null;
        c = member.isVariable() ? container.findContainers(graph, this.typeNode) : container.findContainingContainers(graph, this.typeNode, member);
        QueryIterConcat cIter = new QueryIterConcat(execCxt);
        Var cVar = Var.alloc(containerNode);
        Iterator iter = c.iterator();
        while (iter.hasNext()) {
            Node cn = (Node)iter.next();
            Binding1 b = new Binding1(binding, cVar, cn);
            Node m = member;
            if (Var.isVar(member) && member.equals((Object)cVar)) {
                m = cn;
            }
            cIter.add(this.oneContainer(b, cn, m, execCxt));
        }
        return cIter;
    }

    private QueryIterator oneContainer(Binding binding, Node containerNode, Node member, ExecutionContext execCxt) {
        if (member.isVariable()) {
            return this.members(binding, containerNode, Var.alloc(member), execCxt);
        }
        return this.verify(binding, containerNode, member, execCxt);
    }

    private QueryIterator members(Binding binding, Node containerNode, Var memberVar, ExecutionContext execCxt) {
        Collection x = GraphContainerUtils.containerMembers(execCxt.getActiveGraph(), containerNode, this.typeNode);
        if (x == null) {
            return ProcLib.noResults(execCxt);
        }
        ArrayList<Binding1> bindings = new ArrayList<Binding1>();
        Iterator iter = x.iterator();
        while (iter.hasNext()) {
            Node n = (Node)iter.next();
            Binding1 b = new Binding1(binding, memberVar, n);
            bindings.add(b);
        }
        return new QueryIterPlainWrapper(bindings.iterator(), execCxt);
    }

    private QueryIterator verify(Binding binding, Node containerNode, Node member, ExecutionContext execCxt) {
        int count = GraphContainerUtils.countContainerMember(execCxt.getActiveGraph(), containerNode, this.typeNode, member);
        return new QueryIterYieldN(count, binding, execCxt);
    }

    private static Collection findContainers(Graph graph, Node typeNode) {
        HashSet acc = new HashSet();
        if (typeNode != null) {
            container.findContainers(acc, graph, typeNode);
            return acc;
        }
        container.findContainers(acc, graph, RDF.Bag.asNode());
        container.findContainers(acc, graph, RDF.Seq.asNode());
        container.findContainers(acc, graph, RDF.Alt.asNode());
        return acc;
    }

    private static void findContainers(Collection acc, Graph graph, Node typeNode) {
        ExtendedIterator iter = graph.find(Node.ANY, RDF.type.asNode(), typeNode);
        while (iter.hasNext()) {
            Triple t = (Triple)iter.next();
            Node containerNode = t.getSubject();
            acc.add(containerNode);
        }
    }

    private static Collection findContainingContainers(Graph graph, Node typeNode, Node member) {
        HashSet<Node> acc = new HashSet<Node>();
        ExtendedIterator iter = graph.find(Node.ANY, Node.ANY, member);
        while (iter.hasNext()) {
            Triple t = (Triple)iter.next();
            Node containerNode = t.getSubject();
            if (!GraphContainerUtils.isContainer(graph, containerNode, typeNode)) continue;
            acc.add(containerNode);
        }
        return acc;
    }
}

