/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.modify.lang.parser;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.sparql.lang.ParserBase;
import com.hp.hpl.jena.sparql.modify.lang.ParserUpdateBase;
import com.hp.hpl.jena.sparql.modify.lang.parser.SPARQLUpdateParserConstants;
import com.hp.hpl.jena.sparql.syntax.Template;
import com.hp.hpl.jena.sparql.syntax.TemplateGroup;
import com.hp.hpl.jena.sparql.syntax.TemplateTriple;
import com.hp.hpl.jena.sparql.syntax.TemplateVisitor;
import com.hp.hpl.jena.sparql.util.graph.GraphUtils;
import com.hp.hpl.jena.update.UpdateRequest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class SPARQLUpdateParserBase
extends ParserUpdateBase
implements SPARQLUpdateParserConstants {
    private UpdateRequest request = null;

    public void setUpdateRequest(UpdateRequest request) {
        this.setPrologue(request);
        this.request = request;
    }

    protected UpdateRequest getRequest() {
        return this.request;
    }

    protected Graph convertTemplateToTriples(Template template, int line, int col) {
        ArrayList acc = new ArrayList();
        TriplesCollector collector = new TriplesCollector(acc, line, col);
        template.visit(collector);
        Graph g = GraphUtils.makePlainGraph();
        g.getBulkUpdateHandler().add(acc);
        return g;
    }

    static class TriplesCollector
    implements TemplateVisitor {
        private Collection acc;
        private int line;
        private int col;

        TriplesCollector(Collection acc, int line, int col) {
            this.acc = acc;
            this.line = line;
            this.col = col;
        }

        public void visit(TemplateTriple template) {
            Triple t = template.getTriple();
            if (t.getSubject().isVariable() || t.getPredicate().isVariable() || t.getObject().isVariable()) {
                ParserBase.throwParseException("Triples may not contain variables in ADD or REMOVE", this.line, this.col);
            }
            this.acc.add(t);
        }

        public void visit(TemplateGroup template) {
            Iterator iter = template.getTemplates().iterator();
            while (iter.hasNext()) {
                Template t = (Template)iter.next();
                t.visit(this);
            }
        }
    }
}

