/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.modify;

import com.hp.hpl.jena.graph.Factory;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.sparql.AlreadyExists;
import com.hp.hpl.jena.sparql.DoesNotExist;
import com.hp.hpl.jena.sparql.core.DatasetGraph;
import com.hp.hpl.jena.sparql.engine.Plan;
import com.hp.hpl.jena.sparql.engine.QueryIterator;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.engine.binding.BindingRoot;
import com.hp.hpl.jena.sparql.engine.iterator.QueryIterPlainWrapper;
import com.hp.hpl.jena.sparql.modify.UpdateVisitor;
import com.hp.hpl.jena.sparql.modify.op.UpdateClear;
import com.hp.hpl.jena.sparql.modify.op.UpdateCreate;
import com.hp.hpl.jena.sparql.modify.op.UpdateDelete;
import com.hp.hpl.jena.sparql.modify.op.UpdateDeleteData;
import com.hp.hpl.jena.sparql.modify.op.UpdateDrop;
import com.hp.hpl.jena.sparql.modify.op.UpdateExt;
import com.hp.hpl.jena.sparql.modify.op.UpdateInsert;
import com.hp.hpl.jena.sparql.modify.op.UpdateInsertData;
import com.hp.hpl.jena.sparql.modify.op.UpdateLoad;
import com.hp.hpl.jena.sparql.modify.op.UpdateModify;
import com.hp.hpl.jena.sparql.modify.op.UpdateModifyBase;
import com.hp.hpl.jena.sparql.syntax.Element;
import com.hp.hpl.jena.sparql.syntax.Template;
import com.hp.hpl.jena.sparql.util.ALog;
import com.hp.hpl.jena.sparql.util.FmtUtils;
import com.hp.hpl.jena.update.GraphStore;
import com.hp.hpl.jena.update.UpdateException;
import com.hp.hpl.jena.util.FileManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class UpdateProcessorVisitor
implements UpdateVisitor {
    private GraphStore graphStore;
    private Binding binding;
    static /* synthetic */ Class class$com$hp$hpl$jena$sparql$modify$UpdateProcessorVisitor;

    public UpdateProcessorVisitor(GraphStore graphStore, Binding initialBinding) {
        this.graphStore = graphStore;
        this.binding = initialBinding;
    }

    public void visit(final UpdateInsertData insertData) {
        this.action(insertData.getGraphNames(), new Action(){

            public void exec(Graph graph) {
                graph.getBulkUpdateHandler().add(insertData.getData());
            }
        });
    }

    public void visit(final UpdateDeleteData deleteData) {
        this.action(deleteData.getGraphNames(), new Action(){

            public void exec(Graph graph) {
                graph.getBulkUpdateHandler().delete(deleteData.getData());
            }
        });
    }

    public void visit(UpdateModify modify) {
        this.visitModify(modify);
    }

    public void visit(UpdateDelete delete) {
        this.visitModify(delete);
    }

    public void visit(UpdateInsert insert) {
        this.visitModify(insert);
    }

    private void visitModify(final UpdateModifyBase modify) {
        final List bindings = this.evalBindings(modify.getElement());
        this.action(modify.getGraphNames(), new Action(){

            public void exec(Graph graph) {
                UpdateProcessorVisitor.this.execDeletes(modify, graph, bindings);
            }
        });
        this.action(modify.getGraphNames(), new Action(){

            public void exec(Graph graph) {
                UpdateProcessorVisitor.this.execInserts(modify, graph, bindings);
            }
        });
    }

    private List evalBindings(Element pattern) {
        ArrayList<Binding> bindings = new ArrayList<Binding>();
        if (pattern != null) {
            Plan plan = QueryExecutionFactory.createPlan(pattern, (DatasetGraph)this.graphStore, this.binding);
            QueryIterator qIter = plan.iterator();
            while (qIter.hasNext()) {
                Binding b = qIter.nextBinding();
                bindings.add(b);
            }
            qIter.close();
        } else {
            bindings.add(BindingRoot.create());
        }
        return bindings;
    }

    private void execDeletes(UpdateModifyBase modify, Graph graph, List bindings) {
        if (modify.getDeletes() != null) {
            QueryIterPlainWrapper qIter = new QueryIterPlainWrapper(bindings.iterator());
            Collection acc = UpdateProcessorVisitor.subst(modify.getDeletes(), qIter);
            graph.getBulkUpdateHandler().delete(acc.iterator());
        }
    }

    private void execInserts(UpdateModifyBase modify, Graph graph, List bindings) {
        if (modify.getInserts() != null) {
            QueryIterPlainWrapper qIter = new QueryIterPlainWrapper(bindings.iterator());
            Collection acc = UpdateProcessorVisitor.subst(modify.getInserts(), qIter);
            graph.getBulkUpdateHandler().add(acc.iterator());
        }
    }

    public void visit(UpdateClear clear) {
        this.action(clear.getGraphName(), new Action(){

            public void exec(Graph graph) {
                graph.getBulkUpdateHandler().removeAll();
            }
        });
    }

    public void visit(final UpdateLoad load) {
        this.action(load.getGraphName(), new Action(){

            public void exec(Graph graph) {
                Model model = ModelFactory.createModelForGraph((Graph)graph);
                Iterator iter = load.getLoadIRIs().iterator();
                while (iter.hasNext()) {
                    String s = (String)iter.next();
                    FileManager.get().readModel(model, s);
                }
            }
        });
    }

    public void visit(UpdateDrop drop) {
        Node n = drop.getIRI();
        if (!this.graphStore.containsGraph(n)) {
            if (drop.isSilent()) {
                return;
            }
            throw new DoesNotExist("Named graph: " + n);
        }
        this.graphStore.removeGraph(n);
    }

    public void visit(UpdateCreate create) {
        Node n = create.getIRI();
        if (this.graphStore.containsGraph(n)) {
            if (create.isSilent()) {
                return;
            }
            throw new AlreadyExists("Named graph: " + n);
        }
        Graph graph = Factory.createDefaultGraph();
        this.graphStore.addGraph(n, graph);
    }

    public void visit(UpdateExt updateExt) {
        updateExt.update();
    }

    private void action(Node graphName, Action action) {
        Graph g = null;
        if (graphName != null) {
            g = this.graphStore.getGraph(graphName);
            if (g == null) {
                throw new UpdateException("No such graph: " + graphName);
            }
        } else {
            g = this.graphStore.getDefaultGraph();
        }
        action.exec(g);
    }

    private void action(List graphNodes, Action action) {
        if (graphNodes.isEmpty()) {
            Graph g = this.graphStore.getDefaultGraph();
            action.exec(g);
        } else {
            Iterator iter = graphNodes.iterator();
            while (iter.hasNext()) {
                Node gn = (Node)iter.next();
                Graph g = this.graphStore.getGraph(gn);
                if (g == null) {
                    throw new UpdateException("No such graph: " + gn);
                }
                action.exec(g);
            }
        }
    }

    protected static Collection subst(Template template, QueryIterator qIter) {
        HashSet acc = new HashSet();
        while (qIter.hasNext()) {
            HashMap bNodeMap = new HashMap();
            Binding b = qIter.nextBinding();
            template.subst(acc, bNodeMap, b);
        }
        Iterator iter = acc.iterator();
        while (iter.hasNext()) {
            Triple triple = (Triple)iter.next();
            if (UpdateProcessorVisitor.isGroundTriple(triple)) continue;
            ALog.warn(class$com$hp$hpl$jena$sparql$modify$UpdateProcessorVisitor == null ? UpdateProcessorVisitor.class$("com.hp.hpl.jena.sparql.modify.UpdateProcessorVisitor") : class$com$hp$hpl$jena$sparql$modify$UpdateProcessorVisitor, "Unbound triple: " + FmtUtils.stringForTriple(triple));
            acc.remove(triple);
        }
        return acc;
    }

    private static boolean isGroundTriple(Triple triple) {
        return UpdateProcessorVisitor.isGroundNode(triple.getSubject()) && UpdateProcessorVisitor.isGroundNode(triple.getPredicate()) && UpdateProcessorVisitor.isGroundNode(triple.getObject());
    }

    private static boolean isGroundNode(Node node) {
        return node.isConcrete();
    }

    static interface Action {
        public void exec(Graph var1);
    }
}

