/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.engine.main;

import com.hp.hpl.jena.query.QueryExecException;
import com.hp.hpl.jena.sparql.ARQNotImplemented;
import com.hp.hpl.jena.sparql.algebra.Op;
import com.hp.hpl.jena.sparql.algebra.op.OpAssign;
import com.hp.hpl.jena.sparql.algebra.op.OpBGP;
import com.hp.hpl.jena.sparql.algebra.op.OpDatasetNames;
import com.hp.hpl.jena.sparql.algebra.op.OpDiff;
import com.hp.hpl.jena.sparql.algebra.op.OpDistinct;
import com.hp.hpl.jena.sparql.algebra.op.OpExt;
import com.hp.hpl.jena.sparql.algebra.op.OpFilter;
import com.hp.hpl.jena.sparql.algebra.op.OpGraph;
import com.hp.hpl.jena.sparql.algebra.op.OpGroupAgg;
import com.hp.hpl.jena.sparql.algebra.op.OpJoin;
import com.hp.hpl.jena.sparql.algebra.op.OpLeftJoin;
import com.hp.hpl.jena.sparql.algebra.op.OpList;
import com.hp.hpl.jena.sparql.algebra.op.OpNull;
import com.hp.hpl.jena.sparql.algebra.op.OpOrder;
import com.hp.hpl.jena.sparql.algebra.op.OpProcedure;
import com.hp.hpl.jena.sparql.algebra.op.OpProject;
import com.hp.hpl.jena.sparql.algebra.op.OpPropFunc;
import com.hp.hpl.jena.sparql.algebra.op.OpQuadPattern;
import com.hp.hpl.jena.sparql.algebra.op.OpReduced;
import com.hp.hpl.jena.sparql.algebra.op.OpService;
import com.hp.hpl.jena.sparql.algebra.op.OpSlice;
import com.hp.hpl.jena.sparql.algebra.op.OpStage;
import com.hp.hpl.jena.sparql.algebra.op.OpTable;
import com.hp.hpl.jena.sparql.algebra.op.OpUnion;
import com.hp.hpl.jena.sparql.core.BasicPattern;
import com.hp.hpl.jena.sparql.engine.ExecutionContext;
import com.hp.hpl.jena.sparql.engine.QueryIterator;
import com.hp.hpl.jena.sparql.engine.iterator.QueryIterDiff;
import com.hp.hpl.jena.sparql.engine.iterator.QueryIterDistinct;
import com.hp.hpl.jena.sparql.engine.iterator.QueryIterExtend;
import com.hp.hpl.jena.sparql.engine.iterator.QueryIterGroup;
import com.hp.hpl.jena.sparql.engine.iterator.QueryIterNullIterator;
import com.hp.hpl.jena.sparql.engine.iterator.QueryIterProcedure;
import com.hp.hpl.jena.sparql.engine.iterator.QueryIterProject;
import com.hp.hpl.jena.sparql.engine.iterator.QueryIterReduced;
import com.hp.hpl.jena.sparql.engine.iterator.QueryIterRoot;
import com.hp.hpl.jena.sparql.engine.iterator.QueryIterSlice;
import com.hp.hpl.jena.sparql.engine.iterator.QueryIterSort;
import com.hp.hpl.jena.sparql.engine.main.CompilerDispatch;
import com.hp.hpl.jena.sparql.engine.main.FilterPlacement;
import com.hp.hpl.jena.sparql.engine.main.JoinClassifier;
import com.hp.hpl.jena.sparql.engine.main.LeftJoinClassifier;
import com.hp.hpl.jena.sparql.engine.main.OpExtMain;
import com.hp.hpl.jena.sparql.engine.main.StageBuilder;
import com.hp.hpl.jena.sparql.engine.main.iterator.QueryIterGraph;
import com.hp.hpl.jena.sparql.engine.main.iterator.QueryIterJoin;
import com.hp.hpl.jena.sparql.engine.main.iterator.QueryIterLeftJoin;
import com.hp.hpl.jena.sparql.engine.main.iterator.QueryIterOptionalIndex;
import com.hp.hpl.jena.sparql.engine.main.iterator.QueryIterService;
import com.hp.hpl.jena.sparql.engine.main.iterator.QueryIterUnion;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.ExprBuild;
import com.hp.hpl.jena.sparql.expr.ExprList;
import com.hp.hpl.jena.sparql.expr.ExprWalker;
import com.hp.hpl.jena.sparql.procedure.ProcEval;
import com.hp.hpl.jena.sparql.procedure.Procedure;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class OpCompiler {
    public static Factory factory = new Factory(){

        public OpCompiler create(ExecutionContext execCxt) {
            return new OpCompiler(execCxt);
        }
    };
    protected ExecutionContext execCxt;
    protected CompilerDispatch dispatcher = null;
    protected FilterPlacement filterPlacement;

    public static QueryIterator compile(Op op, ExecutionContext execCxt) {
        return OpCompiler.compile(op, OpCompiler.root(execCxt), execCxt);
    }

    public static QueryIterator compile(Op op, QueryIterator qIter, ExecutionContext execCxt) {
        OpCompiler compiler = null;
        compiler = factory == null ? new OpCompiler(execCxt) : factory.create(execCxt);
        QueryIterator q = compiler.compileOp(op, qIter);
        return q;
    }

    protected OpCompiler(ExecutionContext execCxt) {
        this.execCxt = execCxt;
        this.dispatcher = new CompilerDispatch(this);
        this.filterPlacement = new FilterPlacement(this, execCxt);
    }

    public QueryIterator compileOp(Op op) {
        return this.compileOp(op, null);
    }

    public QueryIterator compileOp(Op op, QueryIterator input) {
        return this.dispatcher.compile(op, input);
    }

    public QueryIterator compile(OpBGP opBGP, QueryIterator input) {
        BasicPattern pattern = opBGP.getPattern();
        return StageBuilder.compile(pattern, input, this.execCxt);
    }

    public QueryIterator compile(OpQuadPattern quadPattern, QueryIterator input) {
        throw new ARQNotImplemented("compile/OpQuadPattern");
    }

    public QueryIterator compile(OpProcedure opProc, QueryIterator input) {
        Procedure procedure = ProcEval.build(opProc, this.execCxt);
        QueryIterator qIter = this.compileOp(opProc.getSubOp(), input);
        return new QueryIterProcedure(qIter, procedure, this.execCxt);
    }

    public QueryIterator compile(OpPropFunc opPropFunc, QueryIterator input) {
        Procedure procedure = ProcEval.build(opPropFunc.getProperty(), opPropFunc.getSubjectArgs(), opPropFunc.getObjectArgs(), this.execCxt);
        QueryIterator qIter = this.compileOp(opPropFunc.getSubOp(), input);
        return new QueryIterProcedure(qIter, procedure, this.execCxt);
    }

    public QueryIterator compile(OpJoin opJoin, QueryIterator input) {
        boolean canDoLinear = JoinClassifier.isLinear(opJoin);
        if (canDoLinear) {
            return this.stream(opJoin.getLeft(), opJoin.getRight(), input);
        }
        QueryIterator left = this.compileOp(opJoin.getLeft(), input);
        QueryIterator right = this.compileOp(opJoin.getRight(), this.root());
        QueryIterJoin qIter = new QueryIterJoin(left, right, this.execCxt);
        return qIter;
    }

    public QueryIterator compile(OpStage opStage, QueryIterator input) {
        return this.stream(opStage.getLeft(), opStage.getRight(), input);
    }

    protected QueryIterator stream(Op opLeft, Op opRight, QueryIterator input) {
        QueryIterator left = this.compileOp(opLeft, input);
        QueryIterator right = this.compileOp(opRight, left);
        return right;
    }

    public QueryIterator compile(OpLeftJoin opLeftJoin, QueryIterator input) {
        ExprList exprs = opLeftJoin.getExprs();
        if (exprs != null) {
            exprs.prepareExprs(this.execCxt.getContext());
        }
        QueryIterator left = this.compileOp(opLeftJoin.getLeft(), input);
        boolean canDoLinear = LeftJoinClassifier.isLinear(opLeftJoin);
        if (canDoLinear) {
            QueryIterOptionalIndex qIter = new QueryIterOptionalIndex(left, opLeftJoin.getRight(), exprs, this.execCxt);
            return qIter;
        }
        QueryIterator right = this.compileOp(opLeftJoin.getRight(), this.root());
        QueryIterLeftJoin qIter = new QueryIterLeftJoin(left, right, exprs, this.execCxt);
        return qIter;
    }

    public QueryIterator compile(OpDiff opDiff, QueryIterator input) {
        QueryIterator left = this.compileOp(opDiff.getLeft(), input);
        QueryIterator right = this.compileOp(opDiff.getRight(), this.root());
        return new QueryIterDiff(left, right, this.execCxt);
    }

    public QueryIterator compile(OpUnion opUnion, QueryIterator input) {
        List x = this.flattenUnion(opUnion);
        QueryIterUnion cIter = new QueryIterUnion(input, x, this.execCxt);
        return cIter;
    }

    protected List flattenUnion(OpUnion opUnion) {
        ArrayList x = new ArrayList();
        this.flattenUnion(x, opUnion);
        return x;
    }

    protected void flattenUnion(List acc, OpUnion opUnion) {
        if (opUnion.getLeft() instanceof OpUnion) {
            this.flattenUnion(acc, (OpUnion)opUnion.getLeft());
        } else {
            acc.add(opUnion.getLeft());
        }
        if (opUnion.getRight() instanceof OpUnion) {
            this.flattenUnion(acc, (OpUnion)opUnion.getRight());
        } else {
            acc.add(opUnion.getRight());
        }
    }

    public QueryIterator compile(OpFilter opFilter, QueryIterator input) {
        OpJoin opJoin;
        boolean canDoLinear;
        ExprList exprs = opFilter.getExprs();
        exprs.prepareExprs(this.execCxt.getContext());
        Op base = opFilter.getSubOp();
        if (base instanceof OpBGP) {
            return this.filterPlacement.placeFiltersBGP(exprs, ((OpBGP)base).getPattern(), input);
        }
        if (base instanceof OpStage) {
            return this.filterPlacement.placeFiltersStage(exprs, (OpStage)base, input);
        }
        if (base instanceof OpGraph) {
            // empty if block
        }
        if (base instanceof OpJoin && (canDoLinear = JoinClassifier.isLinear(opJoin = (OpJoin)base))) {
            return this.filterPlacement.placeFiltersJoin(exprs, (OpJoin)base, input);
        }
        if (base instanceof OpLeftJoin) {
            // empty if block
        }
        if (base instanceof OpUnion) {
            // empty if block
        }
        return this.filterPlacement.buildOpFilter(exprs, base, input);
    }

    protected void prepareExprs(ExprList exprs) {
        Iterator iter = exprs.iterator();
        while (iter.hasNext()) {
            Expr expr = (Expr)iter.next();
            ExprWalker.walk(new ExprBuild(this.execCxt.getContext()), expr);
        }
    }

    public QueryIterator compile(OpGraph opGraph, QueryIterator input) {
        return new QueryIterGraph(input, opGraph, this.execCxt);
    }

    public QueryIterator compile(OpService opService, QueryIterator input) {
        return new QueryIterService(input, opService, this.execCxt);
    }

    public QueryIterator compile(OpDatasetNames dsNames, QueryIterator input) {
        throw new ARQNotImplemented("OpDatasetNames");
    }

    public QueryIterator compile(OpTable opTable, QueryIterator input) {
        if (opTable.isJoinIdentity()) {
            return input;
        }
        if (input instanceof QueryIterRoot) {
            input.close();
            return opTable.getTable().iterator(this.execCxt);
        }
        QueryIterator qIterT = opTable.getTable().iterator(this.execCxt);
        QueryIterJoin qIter = new QueryIterJoin(input, qIterT, this.execCxt);
        return qIter;
    }

    public QueryIterator compile(OpExt opExt, QueryIterator input) {
        if (opExt instanceof OpExtMain) {
            OpExtMain op = (OpExtMain)opExt;
            return op.eval(input, this.execCxt);
        }
        throw new QueryExecException("Encountered unsupport OpExt: " + opExt.getName());
    }

    public QueryIterator compile(OpNull opNull, QueryIterator input) {
        input.close();
        return new QueryIterNullIterator(this.execCxt);
    }

    public QueryIterator compile(OpList opList, QueryIterator input) {
        return this.compileOp(opList.getSubOp(), input);
    }

    public QueryIterator compile(OpOrder opOrder, QueryIterator input) {
        QueryIterator qIter = this.compileOp(opOrder.getSubOp(), input);
        qIter = new QueryIterSort(qIter, opOrder.getConditions(), this.execCxt);
        return qIter;
    }

    public QueryIterator compile(OpProject opProject, QueryIterator input) {
        QueryIterator qIter = this.compileOp(opProject.getSubOp(), input);
        qIter = new QueryIterProject(qIter, opProject.getVars(), this.execCxt);
        return qIter;
    }

    public QueryIterator compile(OpSlice opSlice, QueryIterator input) {
        QueryIterator qIter = this.compileOp(opSlice.getSubOp(), input);
        qIter = new QueryIterSlice(qIter, opSlice.getStart(), opSlice.getLength(), this.execCxt);
        return qIter;
    }

    public QueryIterator compile(OpGroupAgg opGroupAgg, QueryIterator input) {
        QueryIterator qIter = this.compileOp(opGroupAgg.getSubOp(), input);
        qIter = new QueryIterGroup(qIter, opGroupAgg.getGroupVars(), opGroupAgg.getAggregators(), this.execCxt);
        return qIter;
    }

    public QueryIterator compile(OpDistinct opDistinct, QueryIterator input) {
        QueryIterator qIter = this.compileOp(opDistinct.getSubOp(), input);
        qIter = new QueryIterDistinct(qIter, this.execCxt);
        return qIter;
    }

    public QueryIterator compile(OpReduced opReduced, QueryIterator input) {
        QueryIterator qIter = this.compileOp(opReduced.getSubOp(), input);
        qIter = new QueryIterReduced(qIter, this.execCxt);
        return qIter;
    }

    public QueryIterator compile(OpAssign opAssign, QueryIterator input) {
        QueryIterator qIter = this.compileOp(opAssign.getSubOp(), input);
        qIter = new QueryIterExtend(qIter, opAssign.getVarExprList(), this.execCxt);
        return qIter;
    }

    protected static QueryIterator root(ExecutionContext execCxt) {
        return QueryIterRoot.create(execCxt);
    }

    protected QueryIterator root() {
        return OpCompiler.root(this.execCxt);
    }

    public static interface Factory {
        public OpCompiler create(ExecutionContext var1);
    }
}

