/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.core;

import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.sparql.core.VarExprList;
import com.hp.hpl.jena.sparql.syntax.Element;
import com.hp.hpl.jena.sparql.syntax.ElementAssign;
import com.hp.hpl.jena.sparql.syntax.ElementNamedGraph;
import com.hp.hpl.jena.sparql.syntax.ElementSubQuery;
import com.hp.hpl.jena.sparql.syntax.ElementTriplesBlock;
import com.hp.hpl.jena.sparql.syntax.ElementVisitorBase;
import com.hp.hpl.jena.sparql.syntax.ElementWalker;
import com.hp.hpl.jena.sparql.util.VarUtils;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;

public class PatternVars {
    public static Set vars(Element element) {
        return PatternVars.vars(new LinkedHashSet(), element);
    }

    public static Set vars(Set s, Element element) {
        PatternVarsVisitor v = new PatternVarsVisitor(s);
        ElementWalker.walk(element, v);
        return s;
    }

    static class PatternVarsVisitor
    extends ElementVisitorBase {
        private Set acc;

        private PatternVarsVisitor(Set s) {
            this.acc = s;
        }

        public void visit(ElementTriplesBlock el) {
            Iterator iter = el.triples();
            while (iter.hasNext()) {
                Triple t = (Triple)iter.next();
                VarUtils.addVarsFromTriple(this.acc, t);
            }
        }

        public void visit(ElementNamedGraph el) {
            VarUtils.addVar(this.acc, el.getGraphNameNode());
        }

        public void visit(ElementSubQuery el) {
            el.getQuery().setResultVars();
            VarExprList x = el.getQuery().getProject();
            this.acc.addAll(x.getVars());
        }

        public void visit(ElementAssign el) {
            this.acc.add(el.getVar());
        }
    }
}

