/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.algebra;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.query.SortCondition;
import com.hp.hpl.jena.sparql.algebra.Op;
import com.hp.hpl.jena.sparql.algebra.OpVisitorBase;
import com.hp.hpl.jena.sparql.algebra.OpWalker;
import com.hp.hpl.jena.sparql.algebra.Table;
import com.hp.hpl.jena.sparql.algebra.op.OpAssign;
import com.hp.hpl.jena.sparql.algebra.op.OpBGP;
import com.hp.hpl.jena.sparql.algebra.op.OpDatasetNames;
import com.hp.hpl.jena.sparql.algebra.op.OpFilter;
import com.hp.hpl.jena.sparql.algebra.op.OpGraph;
import com.hp.hpl.jena.sparql.algebra.op.OpOrder;
import com.hp.hpl.jena.sparql.algebra.op.OpProject;
import com.hp.hpl.jena.sparql.algebra.op.OpQuadPattern;
import com.hp.hpl.jena.sparql.algebra.op.OpTable;
import com.hp.hpl.jena.sparql.core.Quad;
import java.util.HashSet;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Set;

public class OpVars {
    public static Set patternVars(Op op) {
        HashSet acc = new HashSet();
        OpVars.patternVars(op, acc);
        return acc;
    }

    public static void patternVars(Op op, Set acc) {
        OpWalker.walk(op, new OpVarsPattern(acc));
    }

    public static Set allVars(Op op) {
        HashSet acc = new HashSet();
        OpVars.allVars(op, acc);
        return acc;
    }

    public static void allVars(Op op, Set acc) {
        OpWalker.walk(op, new OpVarsQuery(acc));
    }

    private static void addVarsFromTriple(Set acc, Triple t) {
        OpVars.addVar(acc, t.getSubject());
        OpVars.addVar(acc, t.getPredicate());
        OpVars.addVar(acc, t.getObject());
    }

    private static void addVarsFromQuad(Set acc, Quad q) {
        OpVars.addVar(acc, q.getSubject());
        OpVars.addVar(acc, q.getPredicate());
        OpVars.addVar(acc, q.getObject());
        OpVars.addVar(acc, q.getGraph());
    }

    private static void addVar(Set acc, Node n) {
        if (n == null) {
            return;
        }
        if (n.isVariable()) {
            acc.add(n);
        }
    }

    private static class OpVarsQuery
    extends OpVarsPattern {
        OpVarsQuery(Set acc) {
            super(acc);
        }

        public void visit(OpFilter opFilter) {
            opFilter.getExprs().varsMentioned(this.acc);
        }

        public void visit(OpOrder opOrder) {
            Iterator iter = opOrder.getConditions().iterator();
            while (iter.hasNext()) {
                SortCondition sc = (SortCondition)iter.next();
                Set x = sc.getExpression().getVarsMentioned();
                this.acc.addAll(x);
            }
        }
    }

    private static class OpVarsPattern
    extends OpVisitorBase {
        protected Set acc;

        OpVarsPattern(Set acc) {
            this.acc = acc;
        }

        public void visit(OpBGP opBGP) {
            ListIterator iter = opBGP.getPattern().iterator();
            while (iter.hasNext()) {
                Triple t = (Triple)iter.next();
                OpVars.addVarsFromTriple(this.acc, t);
            }
        }

        public void visit(OpQuadPattern quadPattern) {
            Iterator iter = quadPattern.getQuads().iterator();
            while (iter.hasNext()) {
                Quad quad = (Quad)iter.next();
                OpVars.addVarsFromQuad(this.acc, quad);
            }
        }

        public void visit(OpGraph opGraph) {
            OpVars.addVar(this.acc, opGraph.getNode());
        }

        public void visit(OpDatasetNames dsNames) {
            OpVars.addVar(this.acc, dsNames.getGraphNode());
        }

        public void visit(OpTable opTable) {
            Table t = opTable.getTable();
            this.acc.addAll(t.getVars());
        }

        public void visit(OpProject opProject) {
            this.acc.clear();
            this.acc.addAll(opProject.getVars());
        }

        public void visit(OpAssign opAssign) {
            this.acc.addAll(opAssign.getVarExprList().getVars());
        }
    }
}

