/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query;

import com.hp.hpl.jena.assembler.Assembler;
import com.hp.hpl.jena.query.DataSource;
import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.sparql.core.DataSourceImpl;
import com.hp.hpl.jena.sparql.core.assembler.DataSourceAssembler;
import com.hp.hpl.jena.sparql.util.DatasetUtils;
import com.hp.hpl.jena.sparql.util.graph.GraphUtils;
import com.hp.hpl.jena.util.FileManager;
import java.util.List;

public class DatasetFactory {
    public static DataSource create() {
        return new DataSourceImpl();
    }

    public static DataSource create(Model model) {
        return new DataSourceImpl(model);
    }

    public static Dataset create(List uriList) {
        return DatasetFactory.create(uriList, null, null, null);
    }

    public static Dataset create(String uri) {
        return DatasetFactory.create(uri, null, null, null);
    }

    public static Dataset create(List uriList, FileManager fileManager) {
        return DatasetFactory.create(uriList, null, fileManager, null);
    }

    public static Dataset create(String uri, FileManager fileManager) {
        return DatasetFactory.create(uri, null, fileManager, null);
    }

    public static Dataset createNamed(List namedSourceList, FileManager fileManager) {
        return DatasetFactory.create((List)null, namedSourceList, fileManager, null);
    }

    public static Dataset create(List uriList, List namedSourceList) {
        return DatasetFactory.create(uriList, namedSourceList, null, null);
    }

    public static Dataset create(String uri, List namedSourceList) {
        return DatasetFactory.create(uri, namedSourceList, null, null);
    }

    public static Dataset create(String uri, List namedSourceList, FileManager fileManager, String baseURI) {
        return DatasetUtils.createDataset(uri, namedSourceList, fileManager, baseURI);
    }

    public static Dataset create(List uriList, List namedSourceList, FileManager fileManager, String baseURI) {
        return DatasetUtils.createDataset(uriList, namedSourceList, fileManager, baseURI);
    }

    public static Dataset make(Dataset ds, Model defaultModel) {
        DataSourceImpl ds2 = new DataSourceImpl(ds);
        ds2.setDefaultModel(defaultModel);
        return ds2;
    }

    public static Dataset assemble(String filename) {
        Model model = FileManager.get().loadModel(filename);
        return DatasetFactory.assemble(model);
    }

    public static Dataset assemble(Model model) {
        Resource r = GraphUtils.findRootByType(model, DataSourceAssembler.getType());
        return DatasetFactory.assemble(r);
    }

    public static Dataset assemble(Resource resource) {
        Dataset ds = (Dataset)Assembler.general.open(resource);
        return ds;
    }
}

