package com.finconsgroup.itserr.marketplace.zenodo.bs.client.catalog.dto;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import jakarta.validation.constraints.Email;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.UUID;

/**
 * Data Transfer Object representing a user profile related a catalog item in the Zenodo system.
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@JsonIgnoreProperties(ignoreUnknown = true)
public class CatalogItemUserProfileDto {

    /** The unique identifier */
    private UUID id;

    /** The first name */
    private String firstName;

    /** The last name */
    private String lastName;

    /** The email address */
    @Email
    private String email;

}
