package com.finconsgroup.itserr.marketplace.zenodo.bs.client.catalog;

import com.finconsgroup.itserr.marketplace.zenodo.bs.client.catalog.dto.OutputCatalogItemDto;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;

/**
 * Client interface for interacting with the catalog-bs service.
 */
public interface CatalogBsClient {

    /**
     * Retrieves a single item, by id, with full details
     *
     * @param id the unique identifier of the catalog item to retrieve
     * @return ResponseEntity containing a {@link OutputCatalogItemDto} and HTTP status 200 (OK)
     */
    @Operation(summary = "Get a single item by id with full details")
    @ApiResponses(value = @ApiResponse(responseCode = "200", description = "OK"))
    @GetMapping(path = "/catalog/items/{id}")
    OutputCatalogItemDto getItemById(
            @PathVariable(name = "id") String id
    );

}
