package com.finconsgroup.itserr.marketplace.userprofile.dm.dto;

import com.finconsgroup.itserr.marketplace.userprofile.dm.enums.ThemeType;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;

/**
 * Input DTO for creating or updating a user preference.
 */
@Schema(name = "InputUserPreferenceDto", description = "DTO for creating a user preference")
@Data
@Builder
@AllArgsConstructor
public class InputUserPreferenceDto {

    @Schema(description = "Theme preference of a user", example = "SYSTEM")
    private ThemeType theme;
}
