/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.userprofile.dm.entity;

import com.finconsgroup.itserr.marketplace.core.entity.AbstractUUIDEntity;
import com.finconsgroup.itserr.marketplace.userprofile.dm.entity.EndorsementEntity;
import com.finconsgroup.itserr.marketplace.userprofile.dm.entity.ExpertiseEntity;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.PreUpdate;
import jakarta.persistence.Table;
import jakarta.persistence.Version;
import java.time.Instant;
import java.util.UUID;
import lombok.Generated;

@Entity
@Table(name="endorsement")
public class EndorsementEntity
extends AbstractUUIDEntity {
    @ManyToOne
    @JoinColumn(name="expertise_id", nullable=false)
    private ExpertiseEntity expertise;
    @Column(name="expertise_id", insertable=false, updatable=false)
    private UUID expertiseId;
    @Column(name="endorser_id")
    private UUID endorserId;
    @Column(name="endorsement_order", nullable=false)
    private long endorsementOrder;
    @Column(name="creation_time", nullable=false, updatable=false)
    private Instant creationTime;
    @Column(name="update_time", nullable=false)
    private Instant updateTime;
    @Version
    private long version;

    public void prePersist() {
        super.prePersist();
        Instant now = Instant.now();
        if (this.creationTime == null) {
            this.creationTime = now;
        }
        if (this.updateTime == null) {
            this.updateTime = now;
        }
    }

    @PreUpdate
    public void onUpdate() {
        this.updateTime = Instant.now();
    }

    @Generated
    protected EndorsementEntity(EndorsementEntityBuilder<?, ?> b) {
        super(b);
        this.expertise = b.expertise;
        this.expertiseId = b.expertiseId;
        this.endorserId = b.endorserId;
        this.endorsementOrder = b.endorsementOrder;
        this.creationTime = b.creationTime;
        this.updateTime = b.updateTime;
        this.version = b.version;
    }

    @Generated
    public static EndorsementEntityBuilder<?, ?> builder() {
        return new EndorsementEntityBuilderImpl();
    }

    @Generated
    public ExpertiseEntity getExpertise() {
        return this.expertise;
    }

    @Generated
    public UUID getExpertiseId() {
        return this.expertiseId;
    }

    @Generated
    public UUID getEndorserId() {
        return this.endorserId;
    }

    @Generated
    public long getEndorsementOrder() {
        return this.endorsementOrder;
    }

    @Generated
    public Instant getCreationTime() {
        return this.creationTime;
    }

    @Generated
    public Instant getUpdateTime() {
        return this.updateTime;
    }

    @Generated
    public long getVersion() {
        return this.version;
    }

    @Generated
    public void setExpertise(ExpertiseEntity expertise) {
        this.expertise = expertise;
    }

    @Generated
    public void setExpertiseId(UUID expertiseId) {
        this.expertiseId = expertiseId;
    }

    @Generated
    public void setEndorserId(UUID endorserId) {
        this.endorserId = endorserId;
    }

    @Generated
    public void setEndorsementOrder(long endorsementOrder) {
        this.endorsementOrder = endorsementOrder;
    }

    @Generated
    public void setCreationTime(Instant creationTime) {
        this.creationTime = creationTime;
    }

    @Generated
    public void setUpdateTime(Instant updateTime) {
        this.updateTime = updateTime;
    }

    @Generated
    public void setVersion(long version) {
        this.version = version;
    }

    @Generated
    public String toString() {
        return "EndorsementEntity(expertise=" + String.valueOf(this.getExpertise()) + ", expertiseId=" + String.valueOf(this.getExpertiseId()) + ", endorserId=" + String.valueOf(this.getEndorserId()) + ", endorsementOrder=" + this.getEndorsementOrder() + ", creationTime=" + String.valueOf(this.getCreationTime()) + ", updateTime=" + String.valueOf(this.getUpdateTime()) + ", version=" + this.getVersion() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EndorsementEntity)) {
            return false;
        }
        EndorsementEntity other = (EndorsementEntity)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getEndorsementOrder() != other.getEndorsementOrder()) {
            return false;
        }
        if (this.getVersion() != other.getVersion()) {
            return false;
        }
        UUID this$expertiseId = this.getExpertiseId();
        UUID other$expertiseId = other.getExpertiseId();
        if (this$expertiseId == null ? other$expertiseId != null : !((Object)this$expertiseId).equals(other$expertiseId)) {
            return false;
        }
        UUID this$endorserId = this.getEndorserId();
        UUID other$endorserId = other.getEndorserId();
        if (this$endorserId == null ? other$endorserId != null : !((Object)this$endorserId).equals(other$endorserId)) {
            return false;
        }
        Instant this$creationTime = this.getCreationTime();
        Instant other$creationTime = other.getCreationTime();
        if (this$creationTime == null ? other$creationTime != null : !((Object)this$creationTime).equals(other$creationTime)) {
            return false;
        }
        Instant this$updateTime = this.getUpdateTime();
        Instant other$updateTime = other.getUpdateTime();
        return !(this$updateTime == null ? other$updateTime != null : !((Object)this$updateTime).equals(other$updateTime));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof EndorsementEntity;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        long $endorsementOrder = this.getEndorsementOrder();
        result = result * 59 + (int)($endorsementOrder >>> 32 ^ $endorsementOrder);
        long $version = this.getVersion();
        result = result * 59 + (int)($version >>> 32 ^ $version);
        UUID $expertiseId = this.getExpertiseId();
        result = result * 59 + ($expertiseId == null ? 43 : ((Object)$expertiseId).hashCode());
        UUID $endorserId = this.getEndorserId();
        result = result * 59 + ($endorserId == null ? 43 : ((Object)$endorserId).hashCode());
        Instant $creationTime = this.getCreationTime();
        result = result * 59 + ($creationTime == null ? 43 : ((Object)$creationTime).hashCode());
        Instant $updateTime = this.getUpdateTime();
        result = result * 59 + ($updateTime == null ? 43 : ((Object)$updateTime).hashCode());
        return result;
    }

    @Generated
    public EndorsementEntity() {
    }
}

