package com.finconsgroup.itserr.marketplace.userprofile.dm.repository;

import com.finconsgroup.itserr.marketplace.userprofile.dm.entity.EndorsementEntity;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.stereotype.Repository;

import java.util.Optional;
import java.util.UUID;

/**
 * {@link EndorsementRepository} repository.
 */
@Repository
public interface EndorsementRepository extends JpaRepository<EndorsementEntity, UUID> {

    /**
     * checks if a user is already subscribed to a program
     *
     * @param expertiseId the unique identifier of the endorsed user expertise
     * @param endorserId  the unique identifier of a user
     */
    boolean existsByExpertiseIdAndEndorserId(UUID expertiseId, UUID endorserId);

    /**
     * Retrieves the endorsement entry by expertiseId and userId
     *
     * @param expertiseId the unique identifier of the endorsed user expertise
     * @param endorserId  the unique identifier of a user
     */
    Optional<EndorsementEntity> findByExpertiseIdAndEndorserId(UUID expertiseId, UUID endorserId);

}