package com.finconsgroup.itserr.marketplace.userprofile.dm.service;

import com.finconsgroup.itserr.marketplace.core.web.exception.WP2DuplicateResourceException;
import com.finconsgroup.itserr.marketplace.core.web.exception.WP2ResourceNotFoundException;
import com.finconsgroup.itserr.marketplace.core.web.exception.WP2ValidationException;
import com.finconsgroup.itserr.marketplace.userprofile.dm.dto.OutputEndorsementAcknowledgementDto;
import org.springframework.lang.NonNull;

import java.util.UUID;

/**
 * Service for handling business logic related to Endorsements. This interface provides methods to add and remove to an Endorsement.
 */
public interface EndorsementService {

    /**
     * Endorses a specific expertise of a user profile.
     *
     * @param userId      the id of the endorser
     * @param profileId   the id of the endorsed user
     * @param expertiseId the id of the expertise
     * @throws WP2ResourceNotFoundException  if no user profile is found for the given user id
     * @throws WP2DuplicateResourceException if user has already endorsed to the program
     * @throws WP2ValidationException        if user tries to endorse his own expertise
     */
    @NonNull
    OutputEndorsementAcknowledgementDto addEndorsement(@NonNull UUID userId,
                                                       @NonNull UUID profileId,
                                                       @NonNull UUID expertiseId);

    /**
     * Delete an existing endorsement.
     *
     * @param userId      the id of the endorser
     * @param profileId   the id of the endorsed user
     * @param expertiseId the id of the expertise
     * @throws WP2ResourceNotFoundException if no user profile is found for the given user id
     */
    @NonNull
    void removeEndorsement(@NonNull UUID userId,
                           @NonNull UUID profileId,
                           @NonNull UUID expertiseId);

}
