package com.finconsgroup.itserr.marketplace.userprofile.dm.service;

import com.finconsgroup.itserr.marketplace.userprofile.dm.dto.InputAdminPatchUserProfileDto;
import com.finconsgroup.itserr.marketplace.userprofile.dm.dto.OutputAdminPatchUserProfileDto;
import org.springframework.lang.NonNull;

import java.util.UUID;

/**
 * Service for handling business logic related to UserProfiles.
 * This interface provides methods to update UserProfiles by admin.
 */
public interface AdminService {

    /**
     * update the user profile public info.
     *
     * @param profileId                     id of the user profile
     * @param inputAdminPatchUserProfileDto which contains information that needs to be patched for an existing entity
     * @return the found {@link OutputAdminPatchUserProfileDto} and HTTP status 200 (OK)
     */
    @NonNull
    OutputAdminPatchUserProfileDto patchUserProfile(@NonNull UUID profileId, @NonNull InputAdminPatchUserProfileDto inputAdminPatchUserProfileDto);
}
