package com.finconsgroup.itserr.marketplace.userprofile.dm.repository;

import com.finconsgroup.itserr.marketplace.userprofile.dm.entity.ProjectEntity;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.stereotype.Repository;

import java.util.List;
import java.util.UUID;

/**
 * {@link ProjectRepository} repository.
 */
@Repository
public interface ProjectRepository extends JpaRepository<ProjectEntity, UUID> {

    List<ProjectEntity> findByUserProfileIdInAndProjectId(List<UUID> userProfileIds, UUID projectId);

    List<ProjectEntity> findByUserProfileIdInAndProjectIdIn(List<UUID> userProfileIds, List<UUID> projectIds);
}