package com.finconsgroup.itserr.marketplace.userprofile.dm.repository;

import com.finconsgroup.itserr.marketplace.userprofile.dm.entity.ExpertiseEntity;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.stereotype.Repository;

import java.util.Optional;
import java.util.UUID;

/**
 * {@link ExpertiseRepository} repository.
 */
@Repository
public interface ExpertiseRepository extends JpaRepository<ExpertiseEntity, UUID> {

    /**
     * checks if expertise exists for the user
     *
     * @param expertiseId the unique identifier of the expertise/skill
     * @param userId      the id of the associated user profile
     */
    Optional<ExpertiseEntity> findByIdAndUserProfileId(UUID expertiseId, UUID userId);

}