package com.finconsgroup.itserr.marketplace.userprofile.dm.mapper;

import com.finconsgroup.itserr.marketplace.userprofile.dm.dto.InputPublicationDto;
import com.finconsgroup.itserr.marketplace.userprofile.dm.dto.OutputPublicationDto;
import com.finconsgroup.itserr.marketplace.userprofile.dm.entity.PublicationEntity;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;

@Mapper(config = MapperConfiguration.class)
public interface PublicationMapper {

    @Mapping(target = "id", ignore = true)
    @Mapping(target = "city", source = "location.city")
    @Mapping(target = "region", source = "location.region")
    @Mapping(target = "country", source = "location.country")
    @Mapping(target = "zipCode", source = "location.zipCode")
    @Mapping(target = "referenceDetails", ignore = true)
    @Mapping(target = "creationTime", ignore = true)
    @Mapping(target = "updateTime", ignore = true)
    @Mapping(target = "version", ignore = true)
    PublicationEntity toEntity(InputPublicationDto dto);

    @Mapping(target = "location.city", source = "city")
    @Mapping(target = "location.region", source = "region")
    @Mapping(target = "location.country", source = "country")
    @Mapping(target = "location.zipCode", source = "zipCode")
    OutputPublicationDto toDto(PublicationEntity entity);

}
