package com.finconsgroup.itserr.marketplace.userprofile.dm.mapper;

import com.finconsgroup.itserr.marketplace.userprofile.dm.entity.ArchivedEndorsementEntity;
import com.finconsgroup.itserr.marketplace.userprofile.dm.entity.EndorsementEntity;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;

@Mapper(config = MapperConfiguration.class)
public interface ArchivedEndorsementMapper {

    /**
     * Maps a {@link EndorsementEntity} into a {@link ArchivedEndorsementEntity}.
     *
     * @param src Source request.
     * @return Mapped entity.
     */
    @Mapping(target = "archiveTime", ignore = true)
    @Mapping(target = "expertise", ignore = true)
    ArchivedEndorsementEntity toArchivedEntity(EndorsementEntity src);
}
