package com.finconsgroup.itserr.marketplace.userprofile.dm.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * Output DTO representing a cv details.
 */
@Schema(name = "OutputCVDto", description = "DTO representing a cv details in responses")
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class OutputCVDto {

    @Schema(description = "URL of the CV file", example = "https://example.com/cv.pdf")
    private String fileUrl;

    @Schema(description = "Filename of the CV", example = "Curriculum Vitae di John Doe")
    private String filename;

    @Schema(description = "Size of the CV file in bytes", example = "123456")
    private long size;
}
