package com.finconsgroup.itserr.marketplace.userprofile.dm.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.Size;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

import static com.finconsgroup.itserr.marketplace.userprofile.dm.util.Constants.VALIDATION_ERROR_FIELD_LENGTH;


/**
 * Input DTO for updating a userprofile.
 */
@Schema(name = "InputUpdateUserProfile", description = "DTO for updating a userprofile")
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class InputUpdateUserProfileDto {

    @Schema(description = "Link of the image of user", example = "https://imageLink")
    @Size(max = 255, message = VALIDATION_ERROR_FIELD_LENGTH)
    private String imageUrl;

    @Schema(description = "CV details of the user")
    @Valid
    private InputCVDto cv;

    @Schema(description = "ORCID identifier of the user", example = "0000-0002-1825-0097")
    private String orcid;

    @Schema(description = "Whether the user is open to collaboration", example = "false")
    private boolean openToCollaboration;

    @Schema(description = "Whether the user's email is publicly visible", example = "true")
    private boolean showPublicEmail;

    @Schema(description = "Personal website URL", example = "https://johndoe.example.com")
    @Size(max = 255, message = VALIDATION_ERROR_FIELD_LENGTH)
    private String personalWebsite;

    @Schema(description = "LinkedIn profile URL", example = "https://linkedin.com/in/johndoe")
    @Size(max = 255, message = VALIDATION_ERROR_FIELD_LENGTH)
    private String linkedinProfile;

    @Schema(description = "Social profile URL (e.g., GitHub)", example = "https://github.com/johndoe")
    @Size(max = 255, message = VALIDATION_ERROR_FIELD_LENGTH)
    private String socialProfile;

    @Schema(description = "Short biography of the user", example = "Ricercatore Legge 210/10 a tempo indeterminato")
    @Size(max = 1000, message = "Bio must be less than 1000 characters")
    private String shortBio;

    @Schema(description = "User's working location details")
    @Valid
    private InputWorkingLocationDto workingLocation;

    @Schema(description = "Organization affiliation", example = "Stanford University")
    @Size(max = 255, message = VALIDATION_ERROR_FIELD_LENGTH)
    private String organizationAffiliation;

    @Schema(description = "Scientific Disciplinary Sectors", example = "[\"INF/01\", \"ING-INF/05\"]")
    private List<String> ssd;

    @Schema(description = "Areas of Expertise")
    @Valid
    private List<InputExpertiseDto> expertises;

    @Schema(description = "List of references")
    @Valid
    private InputReferenceDto references;

    @Schema(description = "User preferred language", example = "EN")
    @NotBlank
    String language;

    @Schema(description = "Whether the user profile is private or public", example = "false")
    private boolean publicProfile;

    @Schema(description = " thematic interests of user", example = "[\"Physics\", \"Maths\"]")
    private List<String> interests;

    @Schema(description = "User preferences")
    @Valid
    private InputUserPreferenceDto preferences;
}
