package com.finconsgroup.itserr.marketplace.userprofile.dm.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;

import java.util.List;

/**
 * Input DTO for creating a reference.
 */
@Schema(name = "InputReferenceDto", description = "DTO for creating a reference")
@Data
@Builder
@AllArgsConstructor
public class InputReferenceDto {

    @Schema(description = "DOI", example = "[\"10.1000/xyz123\", \"10.1000/xyz124\"]")
    private List<String> dois;

    @Schema(description = "manual references")
    @Valid
    private List<InputManualReferenceDto> manualReferences;
}
