package com.finconsgroup.itserr.marketplace.userprofile.dm.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.Size;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;

import static com.finconsgroup.itserr.marketplace.userprofile.dm.util.Constants.VALIDATION_ERROR_FIELD_LENGTH;


/**
 * DTO for author details.
 */
@Schema(name = "InputAuthorDto", description = "DTO for author details")
@Data
@Builder
@AllArgsConstructor
public class InputAuthorDto {

    @Schema(description = "First name of the user", example = "John")
    @Size(max = 100, message = VALIDATION_ERROR_FIELD_LENGTH)
    private String firstName;

    @Schema(description = "Last name of the user", example = "Doe")
    @Size(max = 100, message = VALIDATION_ERROR_FIELD_LENGTH)
    private String lastName;

    @Schema(description = "Email address of the user", example = "john.doe@example.com")
    @Size(max = 255, message = VALIDATION_ERROR_FIELD_LENGTH)
    private String email;

    @Schema(description = "ORCID of the author", example = "0000-0002-1825-0097")
    @Size(max = 255, message = VALIDATION_ERROR_FIELD_LENGTH)
    private String orcid;
}
