package com.finconsgroup.itserr.marketplace.userprofile.dm.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * DTO for patching user profile info.
 */
@Schema(name = "InputAdminPatchUserProfileDto", description = "DTO for patching user profile details")
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class InputAdminPatchUserProfileDto {

    @Schema(description = "Whether the user profile is private or public", example = "false")
    private Boolean publicProfile;
}
