package com.finconsgroup.itserr.marketplace.userprofile.dm.api;

import com.finconsgroup.itserr.marketplace.core.web.exception.ErrorResponseDto;
import com.finconsgroup.itserr.marketplace.userprofile.dm.dto.InputAdminPatchUserProfileDto;
import com.finconsgroup.itserr.marketplace.userprofile.dm.dto.OutputAdminPatchUserProfileDto;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.ResponseStatus;

import java.util.UUID;


/**
 * This interface defines the contract for REST API endpoints related to UserProfile Management.
 *
 * <p>
 * It provides endpoints for updating and patching UserProfiles.
 * </p>
 *
 * <p>Example usage:
 * <pre>
 * PATCH   /admin/profile/{profileId} - update a user profile by ID
 * </pre>
 * </p>
 */
@Tag(
        name = "Admin",
        description = "The Admin API: it provides endpoints for " +
                "patching UserProfiles."
)
@SecurityRequirement(name = "BearerAuth")
public interface AdminApi {

    /**
     * Patch the user profile.
     *
     * @param profileId                     id of the user profile
     * @param inputAdminPatchUserProfileDto which contains information that needs to be updated for an existing entity
     * @return the found {@link OutputAdminPatchUserProfileDto} and HTTP status 200 (OK)
     */
    @Operation(
            summary = "patch a user profile by ID",
            responses = {
                    @ApiResponse(responseCode = "200", description = "OK"),
                    @ApiResponse(responseCode = "404", description = "Not Found",
                            content = {
                                    @Content(
                                            mediaType = MediaType.APPLICATION_JSON_VALUE,
                                            schema = @Schema(implementation = ErrorResponseDto.class)
                                    )
                            }),
            }
    )
    @PatchMapping(value = "/admin/profile/{profileId}", produces = MediaType.APPLICATION_JSON_VALUE)
    @ResponseStatus(HttpStatus.OK)
    OutputAdminPatchUserProfileDto patchUserProfile(@PathVariable("profileId") UUID profileId,
                                                    @RequestBody InputAdminPatchUserProfileDto inputAdminPatchUserProfileDto);
}
