/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.userprofile.dm.repository;

import com.finconsgroup.itserr.marketplace.userprofile.dm.dto.OutputUserProfileAutoCompleteDto;
import com.finconsgroup.itserr.marketplace.userprofile.dm.entity.UserProfileEntity;
import jakarta.validation.constraints.NotEmpty;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Repository;

@Repository
public interface UserProfileRepository
extends JpaRepository<UserProfileEntity, UUID> {
    @NonNull
    public Page<UserProfileEntity> findAllByIdIn(@NonNull Collection<UUID> var1, @NonNull Pageable var2);

    @Query(value="SELECT NEW com.finconsgroup.itserr.marketplace.userprofile.dm.dto.OutputUserProfileAutoCompleteDto(u.id, u.firstName, u.lastName, u.preferredUsername, u.email, u.imageUrl) FROM UserProfileEntity u WHERE LOWER(u.preferredUsername) LIKE LOWER(CONCAT('%', CONCAT(:term, '%'))) OR LOWER(u.firstName) LIKE LOWER(CONCAT('%', CONCAT(:term, '%'))) OR LOWER(u.lastName) LIKE LOWER(CONCAT('%', CONCAT(:term, '%')))")
    public Page<OutputUserProfileAutoCompleteDto> findUsersForAutocomplete(@Param(value="term") String var1, @NonNull Pageable var2);

    @NonNull
    public Page<UserProfileEntity> findAllByPreferredUsernameIn(@NotEmpty Collection<String> var1, Pageable var2);

    @Query(value="SELECT up FROM UserProfileEntity up WHERE CAST(up.id AS string) IN :tokenInfos OR up.email IN :tokenInfos OR up.preferredUsername IN :tokenInfos")
    public List<UserProfileEntity> findByMixedTokenInfo(@Param(value="tokenInfos") List<String> var1);

    @Query(value="  with strings_to_check as (\n    select\n      lower(unnest(string_to_array(:stringsToCheck, :delimiter))) as str),\n  up_interests as (\n    select\n      up.id,\n      lower(unnest(string_to_array(convert_from(lo_get(up.interests::oid), 'UTF-8'), :interestsDelimiter))) as interests\n    from\n      user_profile up\n    where up.public_profile = true\n  )\n    select\n      distinct up_interests.id\n    from\n      up_interests\n    cross join strings_to_check\n    where\n      /* strings_to_check.str like '%' || interests || '%'  -- contains check */\n      regexp_like(strings_to_check.str, '\\y' || interests || '\\y', 'i') /* words check */\n    order by up_interests.id\n", nativeQuery=true)
    public List<UUID> findMatchingInterests(@Param(value="stringsToCheck") String var1, @Param(value="delimiter") String var2, @Param(value="interestsDelimiter") String var3);
}

