/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.userprofile.dm.controller;

import com.finconsgroup.itserr.marketplace.core.web.security.jwt.JwtTokenHolder;
import com.finconsgroup.itserr.marketplace.userprofile.dm.api.UserProfileApi;
import com.finconsgroup.itserr.marketplace.userprofile.dm.dto.AuthenticatedUser;
import com.finconsgroup.itserr.marketplace.userprofile.dm.dto.InputAddProjectToUserProfilesDto;
import com.finconsgroup.itserr.marketplace.userprofile.dm.dto.InputFindUserProfilesByIdsDto;
import com.finconsgroup.itserr.marketplace.userprofile.dm.dto.InputFindUserProfilesByInterestsDto;
import com.finconsgroup.itserr.marketplace.userprofile.dm.dto.InputFindUserProfilesByPrincipalsDto;
import com.finconsgroup.itserr.marketplace.userprofile.dm.dto.InputFindUserProfilesByTokenInfoDto;
import com.finconsgroup.itserr.marketplace.userprofile.dm.dto.InputPatchUserProfileDto;
import com.finconsgroup.itserr.marketplace.userprofile.dm.dto.InputPatchUserProfileProjectDto;
import com.finconsgroup.itserr.marketplace.userprofile.dm.dto.InputRemoveProjectFromUserProfilesDto;
import com.finconsgroup.itserr.marketplace.userprofile.dm.dto.InputUpdateUserProfileDto;
import com.finconsgroup.itserr.marketplace.userprofile.dm.dto.InputUserProfileDto;
import com.finconsgroup.itserr.marketplace.userprofile.dm.dto.OutputPatchUserProfileDto;
import com.finconsgroup.itserr.marketplace.userprofile.dm.dto.OutputUserProfileAutoCompleteDto;
import com.finconsgroup.itserr.marketplace.userprofile.dm.dto.OutputUserProfileDto;
import com.finconsgroup.itserr.marketplace.userprofile.dm.dto.OutputUserProfileFolderDetailsDto;
import com.finconsgroup.itserr.marketplace.userprofile.dm.service.UserProfileService;
import java.util.List;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.lang.NonNull;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class UserProfileController
implements UserProfileApi {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UserProfileController.class);
    private final UserProfileService userProfileService;

    public OutputUserProfileDto create(InputUserProfileDto inputUserProfileDto) {
        return this.userProfileService.create(AuthenticatedUser.fromJwt(), inputUserProfileDto);
    }

    public Page<OutputUserProfileDto> findAll(int pageNumber, int pageSize, String sort, Sort.Direction direction) {
        PageRequest pageable = PageRequest.of((int)pageNumber, (int)pageSize, (Sort.Direction)direction, (String[])new String[]{sort});
        return this.userProfileService.findAll((Pageable)pageable);
    }

    public OutputUserProfileDto findById() {
        return this.userProfileService.findById(AuthenticatedUser.fromJwt());
    }

    public OutputUserProfileDto getById(UUID profileId) {
        return this.userProfileService.getById(profileId);
    }

    public Page<OutputUserProfileDto> findAllByIds(InputFindUserProfilesByIdsDto dto, int pageNumber, int pageSize, String sort, Sort.Direction direction) {
        PageRequest pageable = PageRequest.of((int)pageNumber, (int)pageSize, (Sort.Direction)direction, (String[])new String[]{sort});
        return this.userProfileService.findAllByIds(dto, (Pageable)pageable);
    }

    public Page<OutputUserProfileAutoCompleteDto> getAutoCompletions(String terms, int pageNumber, int pageSize, String sort, Sort.Direction direction) {
        PageRequest pageable = PageRequest.of((int)pageNumber, (int)pageSize, (Sort.Direction)direction, (String[])new String[]{sort});
        return this.userProfileService.getAutoCompletions(terms, (Pageable)pageable);
    }

    public OutputUserProfileDto updateById(InputUpdateUserProfileDto inputUpdateUserProfileDto) {
        UUID userId = JwtTokenHolder.getUserIdOrThrow();
        return this.userProfileService.updateById(userId, inputUpdateUserProfileDto);
    }

    public OutputUserProfileFolderDetailsDto getUserProfileFolderId() {
        UUID userId = JwtTokenHolder.getUserIdOrThrow();
        return this.userProfileService.getUserProfileFolderId(userId);
    }

    public OutputPatchUserProfileDto patchUserProfile(InputPatchUserProfileDto patchUserProfileDto) {
        return this.userProfileService.patchUserProfileInfo(patchUserProfileDto);
    }

    public Page<OutputUserProfileDto> findAllByPrincipals(InputFindUserProfilesByPrincipalsDto inputFindUserProfilesByPrincipalsDto, int pageNumber, int pageSize, String sort, Sort.Direction direction) {
        PageRequest pageable = PageRequest.of((int)pageNumber, (int)pageSize, (Sort.Direction)direction, (String[])new String[]{sort});
        return this.userProfileService.findAllByPrincipals(inputFindUserProfilesByPrincipalsDto, (Pageable)pageable);
    }

    public List<OutputUserProfileDto> addProjectToUserProfiles(@NonNull InputAddProjectToUserProfilesDto inputAddProjectToUserProfilesDto) {
        return this.userProfileService.addProjectToUserProfiles(inputAddProjectToUserProfilesDto);
    }

    public List<OutputUserProfileDto> removeProjectFromUserProfiles(@NonNull InputRemoveProjectFromUserProfilesDto inputRemoveProjectFromUserProfilesDto) {
        return this.userProfileService.removeProjectFromUserProfiles(inputRemoveProjectFromUserProfilesDto);
    }

    public List<OutputUserProfileDto> patchUserProfileProject(InputPatchUserProfileProjectDto inputPatchUserProfileProjectDto) {
        return this.userProfileService.patchUserProfileProject(inputPatchUserProfileProjectDto);
    }

    public List<OutputUserProfileDto> findAllByTokenInfo(InputFindUserProfilesByTokenInfoDto inputFindUserProfilesByTokenInfoDto) {
        return this.userProfileService.findAllByTokenInfo(inputFindUserProfilesByTokenInfoDto);
    }

    public void activate() {
        this.userProfileService.processUserProfileStatusChange(JwtTokenHolder.getUserIdOrThrow(), Boolean.valueOf(true));
    }

    public void deactivate() {
        this.userProfileService.processUserProfileStatusChange(JwtTokenHolder.getUserIdOrThrow(), Boolean.valueOf(false));
    }

    public List<UUID> findMatchingInterests(InputFindUserProfilesByInterestsDto dto) {
        return this.userProfileService.findMatchingInterests(dto.getStringsToCheck());
    }

    @Generated
    public UserProfileController(UserProfileService userProfileService) {
        this.userProfileService = userProfileService;
    }
}

