package com.finconsgroup.itserr.marketplace.userprofile.bs.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * Output DTO representing an author details.
 */
@Schema(name = "OutputAuthorDto", description = "DTO representing a author in responses")
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class OutputAuthorDto {

    @Schema(description = "First name of the user", example = "John")
    private String firstName;

    @Schema(description = "Last name of the user", example = "Doe")
    private String lastName;

    @Schema(description = "Email address of the user", example = "john.doe@example.com")
    private String email;

    @Schema(description = "ORCID of the author", example = "0000-0002-1825-0097")
    private String orcid;
}
