/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.userprofile.bs.component;

import com.finconsgroup.itserr.marketplace.core.web.security.jwt.JwtTokenHolder;
import com.finconsgroup.itserr.marketplace.userprofile.bs.bean.UserProfileApplicationEvent;
import com.finconsgroup.itserr.marketplace.userprofile.bs.component.MessagingUserProfileApplicationEventListener;
import com.finconsgroup.itserr.marketplace.userprofile.bs.dto.OutputUserProfileDto;
import com.finconsgroup.itserr.marketplace.userprofile.bs.dto.UserProfileMessagingAdditionalDataDto;
import com.finconsgroup.itserr.marketplace.userprofile.bs.mapper.UserProfileMapper;
import com.finconsgroup.itserr.marketplace.userprofile.bs.messaging.EventProducer;
import com.finconsgroup.itserr.marketplace.userprofile.bs.messaging.ResourceProducer;
import com.finconsgroup.itserr.messaging.dto.MessagingEventDto;
import com.finconsgroup.itserr.messaging.dto.MessagingEventUserDto;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationListener;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Component;

@Component
public class MessagingUserProfileApplicationEventListener
implements ApplicationListener<UserProfileApplicationEvent> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MessagingUserProfileApplicationEventListener.class);
    private final EventProducer eventProducer;
    private final ResourceProducer resourceProducer;
    private final UserProfileMapper userProfileMapper;

    public void onApplicationEvent(@NonNull UserProfileApplicationEvent event) {
        MessagingEventDto messagingEventDto = this.userProfileMapper.toMessagingEventDto(event.getUserProfileDto());
        MessagingEventUserDto user = MessagingEventUserDto.builder().id((UUID)JwtTokenHolder.getUserId().orElse(null)).name((String)JwtTokenHolder.getName().orElse(null)).username((String)JwtTokenHolder.getPreferredUsername().orElse(null)).build();
        messagingEventDto.setUser(user);
        this.updateEventForType(event, messagingEventDto);
        this.publishEventForType(event, messagingEventDto);
    }

    private void updateEventForType(@NonNull UserProfileApplicationEvent event, @NonNull MessagingEventDto<UserProfileMessagingAdditionalDataDto> messagingEventDto) {
        OutputUserProfileDto userProfileDto = event.getUserProfileDto();
        UserProfileMessagingAdditionalDataDto additionalData = new UserProfileMessagingAdditionalDataDto();
        additionalData.setImageUrl(userProfileDto.getImageUrl());
        switch (1.$SwitchMap$com$finconsgroup$itserr$marketplace$userprofile$bs$enums$MessagingEventType[event.getEventType().ordinal()]) {
            case 1: {
                messagingEventDto.setTimestamp(userProfileDto.getCreationTime().toInstant());
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                messagingEventDto.setTimestamp(userProfileDto.getUpdateTime().toInstant());
                break;
            }
            case 6: {
                messagingEventDto.setTimestamp(event.getEventTimestamp());
            }
        }
        messagingEventDto.setAdditionalData((Object)additionalData);
    }

    private void publishEventForType(@NonNull UserProfileApplicationEvent event, @NonNull MessagingEventDto<UserProfileMessagingAdditionalDataDto> messagingEventDto) {
        switch (1.$SwitchMap$com$finconsgroup$itserr$marketplace$userprofile$bs$enums$MessagingEventType[event.getEventType().ordinal()]) {
            case 1: {
                this.resourceProducer.publishCreatedResource(event.getUserProfileDto());
                this.eventProducer.publishCreateEvent(messagingEventDto);
                break;
            }
            case 2: {
                this.resourceProducer.publishUpdatedResource(event.getUserProfileDto());
                this.eventProducer.publishUpdateEvent(messagingEventDto);
                break;
            }
            case 6: {
                this.resourceProducer.publishDeletedResource(event.getUserProfileDto());
                this.eventProducer.publishDeleteEvent(messagingEventDto);
                break;
            }
            case 3: {
                this.resourceProducer.publishUpdatedResource(event.getUserProfileDto());
                this.eventProducer.publishUpdateCVEvent(messagingEventDto);
                break;
            }
            case 4: {
                this.resourceProducer.publishUpdatedResource(event.getUserProfileDto());
                this.eventProducer.publishUpdateImageEvent(messagingEventDto);
                break;
            }
            case 5: {
                this.resourceProducer.publishUpdatedResource(event.getUserProfileDto());
                this.eventProducer.publishUpdateLanguageEvent(messagingEventDto);
            }
        }
    }

    @Generated
    public MessagingUserProfileApplicationEventListener(EventProducer eventProducer, ResourceProducer resourceProducer, UserProfileMapper userProfileMapper) {
        this.eventProducer = eventProducer;
        this.resourceProducer = resourceProducer;
        this.userProfileMapper = userProfileMapper;
    }
}

