package com.finconsgroup.itserr.marketplace.userprofile.bs.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotBlank;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.time.ZonedDateTime;
import java.util.List;
import java.util.UUID;

/**
 * Output DTO representing a userprofile.
 */
@Schema(name = "OutputUserProfile", description = "DTO representing a userprofile in responses")
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class OutputUserProfileDto {

    @Schema(description = "Unique identifier of the user profile", example = "550e8400-e29b-41d4-a716-446655440000")
    private UUID id;

    @Schema(description = "First name of the user", example = "John")
    private String firstName;

    @Schema(description = "Last name of the user", example = "Doe")
    private String lastName;

    @Schema(description = "Email address of the user", example = "john.doe@example.com")
    private String email;

    @Schema(description = "preferred Username of the user", example = "john.doe.213213")
    private String preferredUsername;

    @Schema(description = "Link of the image of user", example = "https://imageLink")
    private String imageUrl;

    @Schema(description = "List of projects")
    private List<OutputProjectDto> projects;

    @Schema(description = "CV details of the user")
    private OutputCVDto cv;

    @Schema(description = "ORCID identifier of the user", example = "0000-0002-1825-0097")
    private String orcid;

    @Schema(description = "Whether the user is open to collaboration", example = "false")
    private boolean openToCollaboration;

    @Schema(description = "Whether the user's email is publicly visible", example = "true")
    private boolean showPublicEmail;

    @Schema(description = "Personal website URL", example = "https://johndoe.example.com")
    private String personalWebsite;

    @Schema(description = "LinkedIn profile URL", example = "https://linkedin.com/in/johndoe")
    private String linkedinProfile;

    @Schema(description = "Social profile URL (e.g., GitHub)", example = "https://github.com/johndoe")
    private String socialProfile;

    @Schema(description = "Short biography of the user", example = "Ricercatore Legge 210/10 a tempo indeterminato")
    private String shortBio;

    @Schema(description = "User's working location details")
    private OutputWorkingLocationDto workingLocation;

    @Schema(description = "Organization affiliation", example = "Stanford University")
    private String organizationAffiliation;

    @Schema(description = "Scientific Disciplinary Sectors", example = "[\"INF/01\", \"ING-INF/05\"]")
    private List<String> ssd;

    @Schema(description = "Areas of Expertise")
    private List<OutputExpertiseDto> expertises;

    @Schema(description = "List of references")
    @Valid
    private OutputReferenceDto references;

    @Schema(description = "The creation time of the table record", example = "2025-04-06T10:15:30+01:00")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd'T'HH:mm:ssXXX")
    private ZonedDateTime creationTime;

    @Schema(description = "The last update time of the table record", example = "2025-04-06T10:15:30+01:00")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd'T'HH:mm:ssXXX")
    private ZonedDateTime updateTime;

    @Schema(description = "User preferred language")
    @NotBlank
    private String language;

    @Schema(description = "Whether the user profile is private or public", example = "false")
    private boolean publicProfile;

    @Schema(description = " thematic interests of user", example = "[\"Physics\", \"Maths\"]")
    private List<String> interests;

    @Schema(description = "User preferences")
    private OutputUserPreferenceDto preferences;

    @Schema(description = "Whether to show home panel or not", example = "false")
    private Boolean hidePanel;
}
