/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.userprofile.bs.util;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import lombok.Generated;
import org.apache.commons.io.FilenameUtils;

public final class UniqueFilenameGenerator {
    private static final DateTimeFormatter TIMESTAMP_FORMATTER = DateTimeFormatter.ofPattern("yyyyMMddHHmmss");

    public static String generate(String originalFilename) {
        if (originalFilename == null || originalFilename.trim().isEmpty()) {
            throw new IllegalArgumentException("Original filename must not be null or empty");
        }
        String baseName = FilenameUtils.getBaseName((String)originalFilename);
        String extension = FilenameUtils.getExtension((String)originalFilename);
        String timestamp = LocalDateTime.now().format(TIMESTAMP_FORMATTER);
        if (extension.isEmpty()) {
            return String.format("%s_%s", baseName, timestamp);
        }
        return String.format("%s_%s.%s", baseName, timestamp, extension);
    }

    @Generated
    public UniqueFilenameGenerator() {
    }
}

