/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.search.dm.service.impl;

import com.finconsgroup.itserr.marketplace.core.web.bean.QueryFilter;
import com.finconsgroup.itserr.marketplace.core.web.exception.WP2BusinessException;
import com.finconsgroup.itserr.marketplace.core.web.exception.WP2ResourceNotFoundException;
import com.finconsgroup.itserr.marketplace.search.dm.bean.SearchRequest;
import com.finconsgroup.itserr.marketplace.search.dm.config.DefaultSearchProperties;
import com.finconsgroup.itserr.marketplace.search.dm.config.SearchProperties;
import com.finconsgroup.itserr.marketplace.search.dm.config.UserProfileSearchProperties;
import com.finconsgroup.itserr.marketplace.search.dm.dto.InputUserProfileDto;
import com.finconsgroup.itserr.marketplace.search.dm.dto.OutputGlobalSearchAutoCompleteDto;
import com.finconsgroup.itserr.marketplace.search.dm.dto.OutputGlobalSearchDto;
import com.finconsgroup.itserr.marketplace.search.dm.dto.OutputUserProfileDto;
import com.finconsgroup.itserr.marketplace.search.dm.dto.OutputUserProfileLocalSearchDto;
import com.finconsgroup.itserr.marketplace.search.dm.entity.UserProfile;
import com.finconsgroup.itserr.marketplace.search.dm.enums.Category;
import com.finconsgroup.itserr.marketplace.search.dm.event.UserProfileUpdatedEvent;
import com.finconsgroup.itserr.marketplace.search.dm.mapper.UserProfileMapper;
import com.finconsgroup.itserr.marketplace.search.dm.repository.CustomAggregationRepository;
import com.finconsgroup.itserr.marketplace.search.dm.repository.CustomQueryRepository;
import com.finconsgroup.itserr.marketplace.search.dm.repository.UserProfileRepository;
import com.finconsgroup.itserr.marketplace.search.dm.service.UserProfileService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DefaultUserProfileService
implements UserProfileService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultUserProfileService.class);
    private final UserProfileRepository userProfileRepository;
    private final UserProfileMapper userProfileMapper;
    private final UserProfileSearchProperties userProfileSearchProperties;
    private final ApplicationEventPublisher applicationEventPublisher;
    private final Map<String, String> sortFilterPropertyMap;

    public DefaultUserProfileService(UserProfileRepository userProfileRepository, UserProfileMapper userProfileMapper, UserProfileSearchProperties userProfileSearchProperties, DefaultSearchProperties defaultSearchProperties, ApplicationEventPublisher applicationEventPublisher) {
        this.userProfileRepository = userProfileRepository;
        this.userProfileMapper = userProfileMapper;
        this.userProfileSearchProperties = userProfileSearchProperties;
        this.applicationEventPublisher = applicationEventPublisher;
        this.sortFilterPropertyMap = this.buildSortFilterPropertyMap(userProfileSearchProperties.search(), defaultSearchProperties.search().sortFilterPropertyMap());
    }

    @Transactional
    @NonNull
    public OutputUserProfileDto upsertDocument(@NonNull InputUserProfileDto dto) {
        Optional existingUserProfileOpt = this.userProfileRepository.findById((Object)dto.getId());
        UserProfile userProfile = this.userProfileMapper.toEntity(dto);
        UserProfile savedUserProfile = (UserProfile)this.userProfileRepository.save((Object)userProfile);
        this.publishEvents(savedUserProfile, existingUserProfileOpt);
        return this.userProfileMapper.toDto(savedUserProfile);
    }

    @Transactional(readOnly=true)
    @NonNull
    public OutputUserProfileDto getDocument(@NonNull String id) {
        UserProfile savedUserProfile = this.userProfileRepository.findById((Object)id).filter(UserProfile::isPublicProfile).orElseThrow(() -> new WP2ResourceNotFoundException("search_dm_profile_not_found"));
        return this.userProfileMapper.toDto(savedUserProfile);
    }

    @Transactional
    public void deleteDocument(@NonNull String id) {
        if (!this.userProfileRepository.existsById((Object)id)) {
            throw new WP2ResourceNotFoundException("search_dm_profile_not_found");
        }
        this.userProfileRepository.deleteById((Object)id);
    }

    @Transactional
    public void deleteAll() {
        if (!this.userProfileSearchProperties.search().enableDeleteAll()) {
            throw new WP2BusinessException("search_dm_profile_delete_all_not_enabled");
        }
        this.userProfileRepository.deleteAll();
    }

    @NonNull
    @Transactional(readOnly=true)
    public List<OutputGlobalSearchAutoCompleteDto> getAutoCompletions(@NonNull String terms) {
        Page resultPage = this.search(SearchRequest.builder().terms(terms).queryFilters(this.addDefaultFilters(List.of())).build(), this.userProfileSearchProperties.search().autoCompletion().sourceFields(), arg_0 -> ((UserProfileMapper)this.userProfileMapper).toAutoCompleteDataDto(arg_0), (Pageable)PageRequest.of((int)0, (int)this.userProfileSearchProperties.search().autoCompletion().topHitsLimit()));
        if (resultPage.isEmpty()) {
            return List.of();
        }
        return List.of(OutputGlobalSearchAutoCompleteDto.builder().category(Category.PEOPLE.getId()).data(resultPage.getContent()).build());
    }

    @NonNull
    @Transactional(readOnly=true)
    public Page<OutputUserProfileLocalSearchDto> getLocalSearch(String terms, String filters, @NonNull Pageable pageable) {
        SearchRequest searchRequest = SearchRequest.builder().terms(terms).queryFilters(this.addDefaultFilters(this.buildQueryFilters(filters, this.sortFilterPropertyMap))).build();
        Pageable sortedPageable = this.applySort(pageable, this.userProfileSearchProperties.search(), this.sortFilterPropertyMap);
        return this.search(searchRequest, this.userProfileSearchProperties.search().local().sourceFields(), arg_0 -> ((UserProfileMapper)this.userProfileMapper).toLocalSearchDto(arg_0), sortedPageable);
    }

    @NonNull
    @Transactional(readOnly=true)
    public List<OutputGlobalSearchDto> getSearch(@NonNull String terms) {
        Page resultPage = this.search(SearchRequest.builder().terms(terms).queryFilters(this.addDefaultFilters(List.of())).build(), this.userProfileSearchProperties.search().globalSearch().sourceFields(), arg_0 -> ((UserProfileMapper)this.userProfileMapper).toGlobalSearchDataDto(arg_0), (Pageable)PageRequest.of((int)0, (int)this.userProfileSearchProperties.search().globalSearch().topHitsLimit()));
        if (resultPage.isEmpty()) {
            return List.of();
        }
        return List.of(OutputGlobalSearchDto.builder().category(Category.PEOPLE.getId()).data(resultPage.getContent()).build());
    }

    private void publishEvents(@NonNull UserProfile savedUserProfile, @NonNull Optional<UserProfile> existingUserProfileOpt) {
        this.applicationEventPublisher.publishEvent((ApplicationEvent)new UserProfileUpdatedEvent(savedUserProfile, (UserProfile)existingUserProfileOpt.orElse(null)));
    }

    @NonNull
    public Class<UserProfile> getDocumentClass() {
        return UserProfile.class;
    }

    @NonNull
    public SearchProperties getSearchProperties() {
        return this.userProfileSearchProperties.search();
    }

    @NonNull
    public CustomQueryRepository getCustomQueryRepository() {
        return this.userProfileRepository;
    }

    @NonNull
    public CustomAggregationRepository getCustomAggregationRepository() {
        return this.userProfileRepository;
    }

    private List<QueryFilter> addDefaultFilters(@NonNull List<QueryFilter> queryFilters) {
        ArrayList<QueryFilter> filtersWithDefaults = new ArrayList<QueryFilter>(queryFilters);
        filtersWithDefaults.add(QueryFilter.builder().fieldName("publicProfile").filterValues(List.of(Boolean.TRUE.toString())).build());
        return filtersWithDefaults;
    }
}

