package com.finconsgroup.itserr.marketplace.search.dm.dto;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * It represents the persistent structure of supported os field of Institutional Page for both Global and Local search.
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder
@JsonIgnoreProperties(ignoreUnknown = true)
public class InstitutionalPageSupportedOsDto {

    @Schema(description = "The supported macOS version or description.", example = "macOS 12+ supported")
    private String macOs;

    @Schema(description = "The supported linux version or description.", example = "Ubuntu 20.04+")
    private String linux;

    @Schema(description = "The supported windows version or description.", example = "Windows 10+ supported")
    private String windows;
}
